% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{R2}
\alias{R2}
\title{Calculate R2 of a Forecast object}
\usage{
R2(Forecast)
}
\arguments{
\item{Forecast}{Forecast object.}
}
\value{
R2 value.
}
\description{
\code{R2} takes a \code{\link{Forecast}} object and returns the R2 of the
forecast. R2 is calculated as:
\code{cor(forecast, realized)^2}
}
\examples{

my_forecast <- Forecast(
  origin   = as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31")),
  future   = as.Date(c("2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31")),
  forecast = c(4.21, 4.27, 5.32, 5.11),
  realized = c(4.40, 4.45, 4.87, 4.77),
  h_ahead  = 4L
)

R2(my_forecast)

}
