% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude.R
\name{parse_exclusions}
\alias{parse_exclusions}
\title{read a source file and parse all the excluded lines from it}
\usage{
parse_exclusions(
  file,
  exclude = settings$exclude,
  exclude_start = settings$exclude_start,
  exclude_end = settings$exclude_end,
  exclude_linter = settings$exclude_linter,
  exclude_linter_sep = settings$exclude_linter_sep,
  lines = NULL,
  linter_names = NULL
)
}
\arguments{
\item{file}{R source file}

\item{exclude}{regular expression used to mark lines to exclude}

\item{exclude_start}{regular expression used to mark the start of an excluded range}

\item{exclude_end}{regular expression used to mark the end of an excluded range}

\item{exclude_linter}{regular expression used to capture a list of to-be-excluded linters immediately following a
\code{exclude} or \code{exclude_start} marker.}

\item{exclude_linter_sep}{regular expression used to split a linter list into individual linter names for exclusion.}

\item{lines}{a character vector of the content lines of \code{file}}

\item{linter_names}{Names of active linters}
}
\value{
A possibly named list of excluded lines, possibly for specific linters.
}
\description{
read a source file and parse all the excluded lines from it
}
