% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{ineqConstrKernCompute}
\alias{ineqConstrKernCompute}
\title{Kernel Matrix for \code{"lineqDGP"} Models.}
\usage{
ineqConstrKernCompute(u, constrType = c("boundedness", "monotonicity",
  "convexity"), kernType, par, d = 1L)
}
\arguments{
\item{u}{a discretization vector of the input locations.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity".}

\item{kernType}{a character string corresponding to the type of the kernel.
Options: "gaussian", "matern32", "matern52", "exponential".}

\item{par}{the values of the kernel parameters (variance, lengthscale).}

\item{d}{a number corresponding to the dimension of the input space.}
}
\value{
Kernel matrix \eqn{K(u,u)}
}
\description{
Compute the kernel matrix for \code{"lineqDGP"} models.
}
\examples{
x <- seq(0, 1, 0.01)
par <- c(1, 0.1)
Kb <- ineqConstrKernCompute(x, constrType = "boundedness", kernType = "gaussian", par)
image(Kb, main = "covariance matrix for boundedness constraints")
Km <- ineqConstrKernCompute(x, constrType = "monotonicity", kernType = "gaussian", par)
image(Km, main = "covariance matrix for monotonicity constraints")
Kc <- ineqConstrKernCompute(x, constrType = "convexity", kernType = "gaussian", par)
image(Kc, , main = "covariance matrix for convexity constraints")

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{kernCompute}}
}
\author{
A. F. Lopez-Lopera.
}
