% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ordering_methods.R
\name{topsis}
\alias{topsis}
\title{TOPSIS - the Technique for Order of Preference by Similarity to Ideal
Solution.}
\usage{
topsis(decision, weights, impacts)
}
\arguments{
\item{decision}{A numeric matrix with m rows for m alternatives and n columns
for n criterions.}

\item{weights}{A numeric vector with length equal to number of columns in
decision matrix for weights of criterions.}

\item{impacts}{A character vector of '+' and '-' signs for the way that each
criterion influences on the alternatives.}
}
\value{
A data frame including elements:
\describe{
  \item{\code{alt.row}}{Row number of alternatives in decision matrix.}
  \item{\code{score}}{Score of alternatives.}
  \item{\code{rank}}{Rank of alternatives based on score.}
}
Should \code{decision} be a data frame, the row names will be carried over
to the return value.
}
\description{
TOPSIS - the Technique for Order of Preference by Similarity to Ideal
Solution.
}
\examples{
d <- matrix(rpois(12, 5), nrow = 3, ncol = 3)
w <- c(1, 1, 2)
i <- c('+', '-', '+')
topsis(d, w, i)
}
\references{
Yoon, K. P., & Hwang, C. L. (1981).
Multiple Attribute Decision Making: Methods and Applications.
New York: Springer-Verlag. ISBN: 978-3-642-48318-9
}
\author{
Antoni Baum \email{antoni.baum@protonmail.com}
}
