% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{focusing_var_coeff}
\alias{focusing_var_coeff}
\title{focusing on selected variables in the model, and eliminating impacts from other variables.}
\usage{
focusing_var_coeff(model, focus_var_coeff = NULL, focus_var_raw = NULL,
  intercept_include = TRUE, data = NULL)
}
\arguments{
\item{model}{an output of lm or glm}

\item{focus_var_coeff}{NULL or a character vector, choose coeff vars you want to focus. The unselected vars will have coeff values as 0.
Default is NULL, which means to choosing nothing.}

\item{focus_var_raw}{NULL or a character vector, choose raw vars you want to focus. The unselected vars will have coeff values as 0.
Default is NULL, which means to choosing nothing.}

\item{intercept_include}{a boolean, whether to include the intercept (default is TRUE).}

\item{data}{optional, a new dataset to evaluate the categorical variables.
If NULL, then use the data used in model itself.}
}
\value{
a new model with only focused vars having coeff unchanged, and all other vars having coeff as 0.
}
\description{
focusing on selected variables in the model, and eliminating impacts from other variables.
}
\details{
In a model \code{y ~ a + b}. Sometimes you want to fix value of \code{a} and see the variations of \code{b} in \code{y}.
The most straightforward way to code this, as we did in this function, is to make \code{a}'s coefficients as 0, and then use the predict().
}
\examples{

focus_var_raw  = 'carat'

model = lm(price~ cut + carat + I(carat^2) + I(carat^3) +
             I(carat  * depth) + depth,ggplot2::diamonds)
# all coeffs except carat's will be 0
focusing_var_coeff(model, focus_var_coeff = 'carat')
# all coeffs except cut.L's will be 0
focusing_var_coeff(model, focus_var_coeff = 'cut.L')
# all coeffs without raw vars cut or carat will be 0
focusing_var_coeff(model, focus_var_raw = c('cut','carat'))

# if you didn't specify anything, then all vars' coeff will become 0 except intercept
focusing_var_coeff(model)


# if cannot find the focus_var_coeff or focus_var_raw in the model
tryCatch(focusing_var_coeff(model, focus_var_coeff = 'caratdsd'),
         error = function(err) warning(err))
tryCatch(focusing_var_coeff(model, focus_var_raw = '3213'),
         error = function(err) warning(err))

}

