% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_trends.R
\name{gt_f}
\alias{gt_f}
\title{apply_normalisation}
\usage{
gt_f(
  data,
  kw,
  date_col = "date",
  date_type = "weekly starting",
  geo = "all",
  append = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} containing data for analysis}

\item{kw}{a string of the search keyword}

\item{date_col}{a string specifying the date column name}

\item{date_type}{The date column type as either of the following strings:'weekly starting','weekly ending','daily'}

\item{geo}{a string specifying the country code of the search found in \code{countrycode::codelist}}

\item{append}{a boolean specifying whether to return the original data.frame as well as the added column}
}
\value{
\code{data.frame} of the original data with the added google trend column
}
\description{
Normalise data based on pool mean
}
\details{
Normalise data by dividing all values in each pool by that pool's mean
}
\examples{
data = read_xcsv("https://raw.githubusercontent.com/paladinic/data/main/ecomm_data.csv") \%>\% 
  gt_f(kw = 'covid') \%>\% 
  gt_f(kw = 'bitcoin')

}
