% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_process_labels.R
\name{ls_process_labels}
\alias{ls_process_labels}
\title{A function to conveniently process LimeSurvey labels}
\usage{
ls_process_labels(
  data,
  varnameRegExPairs = NULL,
  lengthToWrap = 50,
  lengthToWrapAnchors = 20,
  labelExtractionRegExPair = limonaid::opts$get("labelExtractionRegExPair"),
  leftAnchorRegExPairs = limonaid::opts$get("leftAnchorRegExPairs"),
  rightAnchorRegExPairs = limonaid::opts$get("rightAnchorRegExPairs")
)
}
\arguments{
\item{data}{The dataframe as produced by \code{\link[=ls_import_data]{ls_import_data()}}.}

\item{varnameRegExPairs}{Pairs of regular expressions to replace in the
variable names. This is useful when some pattern can be applied to the
variable names to, for example, add underscores te denote different parts of
the variable name.  This has to be a list of character vectors that each
have length 2.}

\item{lengthToWrap}{At how many characters to wrap the subquestions.}

\item{lengthToWrapAnchors}{At how many characters to wrap the anchors.}

\item{labelExtractionRegExPair}{The regular expression pair used to extract
the labels.}

\item{leftAnchorRegExPairs}{The regular expression pairs to use to extract
the left anchors.}

\item{rightAnchorRegExPairs}{The regular expression pairs to use to extract
the right anchors.}
}
\value{
A dataframe.
}
\description{
This function is meant to quickly parse the variable labels set by
LimeSurvey. It works particularly well with dual anchor array questions,
where the left and right anchors as well as the subquestions are extracted
automatically.
}
\details{
This function processes LimeSurvey variable labels and applies regular
expressions to automatically extract subquestions and left and right
anchors.
}
\examples{

### No examples provided yet; this would require data to be included,
### and that's not available yet.

}
