% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_regress.R
\name{L_regress}
\alias{L_regress}
\title{Likelihood Support for Regression}
\usage{
L_regress(y, x, verb=TRUE)
}
\arguments{
\item{y}{a numeric vector the same length as x.}

\item{x}{a numeric vector.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.LNc - corrected support for linear versus null model.

$S.LN - uncorrected support for linear versus null model.

$S.QLc - corrected support for quadratic versus linear model.

$S.QL - uncorrected support for quadratic versus linear model.

S.QCc = support for quadratic versus cubic model.

$N - sample size.

$p.vals - p values for 3 fits.
}
\description{
This function calculates the supports for different regression fits from 2 vectors of data.
Models include linear, quadratic and cubic (given sufficient data). A plot is
included showing linear (black), quadratic (red) and cubic (blue dashed) lines. P values for
the model fits are also given.
}
\examples{
# for women's world record times for 1500m event example, p 108
years <- c(0.0,	7.1,	8.9,	8.9,	10.1,	12.8,	17.0,	19.1,
25.0, 28.7, 29.7,	29.9,	35.3, 39.8,	40.2,	41.9,	42.1,	44.0,
44.9, 45.0,	45.1, 45.1,	48.9,	52.9,	53.0,	66.1,	87.9)
time <- c(5.30,	5.12,	5.03,	4.79,	4.75,	4.70,	4.63,	4.63,
4.62, 4.59,	4.50,	4.50,	4.32,   4.29,	4.26,	4.21,	4.18,
4.16,	4.12, 4.11,	4.09,	4.02,	3.93,	3.92,	3.87,	3.84,	3.83)

m=L_regress(time, years)
m

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Royall, R. M. (1997). Statistical evidence: A likelihood paradigm. London: Chapman & Hall, ISBN : 978-0412044113

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430
}
\keyword{Likelihood;}
\keyword{cubic}
\keyword{linear;}
\keyword{quadratic;}
\keyword{regression;}
\keyword{support;}
