% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_oceanoptics_converted.R
\name{lr_parse_jaz}
\alias{lr_parse_jaz}
\alias{lr_parse_jazirrad}
\title{Parse OceanInsight converted file}
\usage{
lr_parse_jaz(filename)

lr_parse_jazirrad(filename)
}
\arguments{
\item{filename}{Path of the file to parse}
}
\value{
A named list of two elements:
\itemize{
\item \code{data}: a dataframe with columns "wl", "dark", "white", "scope" and
"processed", in this order.
\item \code{metadata}: a character vector with metadata including:
\itemize{
\item \code{user}: Name of the spectrometer operator
\item \code{date}: Timestamp of the recording (ISO 8601 format)
\item \code{spec_model}: Model of the spectrometer
\item \code{spec_ID}: Unique ID of the spectrometer
\item \code{white_inttime}: Integration time of the white reference (in ms)
\item \code{dark_inttime}: Integration time of the dark reference (in ms)
\item \code{sample_inttime}: Integration time of the sample (in ms)
\item \code{white_avgs}: Number of averaged measurements for the white reference
\item \code{dark_avgs}: Number of averaged measurements for the dark reference
\item \code{sample_avgs}: Number of averaged measurements for the sample
\item \code{white_boxcar}: Boxcar width for the white reference
\item \code{dark_boxcar}: Boxcar width for the dark reference
\item \code{sample_boxcar}: Boxcar width for the sample reference
}
}
}
\description{
Parse OceanInsight (formerly OceanOptics) converted file.
\url{https://www.oceaninsight.com/}
}
\details{
'processed' column computed by official software and provided as is.
}
\examples{
lr_parse_jaz(system.file("testdata", "jazspec.jaz", package = "lightr"))
lr_parse_jazirrad(system.file("testdata", "irrad.JazIrrad",
                  package = "lightr"))

}
