% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRDS.lgb.Booster.R
\name{readRDS.lgb.Booster}
\alias{readRDS.lgb.Booster}
\title{readRDS for \code{lgb.Booster} models (DEPRECATED)}
\usage{
readRDS.lgb.Booster(file, refhook = NULL)
}
\arguments{
\item{file}{a connection or the name of the file where the R object is saved to or read from.}

\item{refhook}{a hook function for handling reference objects.}
}
\value{
\code{lgb.Booster}
}
\description{
Calls \code{readRDS} in what is expected to be a serialized \code{lgb.Booster} object,
             and then restores its handle through \code{lgb.restore_handle}.

             \bold{This function throws a warning and will be removed in future versions.}
}
\examples{
\donttest{
library(lightgbm)
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(
  objective = "regression"
  , metric = "l2"
  , min_data = 1L
  , learning_rate = 1.0
  , num_threads = 2L
)
valids <- list(test = dtest)
model <- lgb.train(
  params = params
  , data = dtrain
  , nrounds = 10L
  , valids = valids
  , early_stopping_rounds = 5L
)
model_file <- tempfile(fileext = ".rds")
saveRDS.lgb.Booster(model, model_file)
new_model <- readRDS.lgb.Booster(model_file)
}
}
