% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.make_serializable.R
\name{lgb.make_serializable}
\alias{lgb.make_serializable}
\title{Make a LightGBM object serializable by keeping raw bytes}
\usage{
lgb.make_serializable(model)
}
\arguments{
\item{model}{\code{lgb.Booster} object which was produced with `serializable=FALSE`.}
}
\value{
\code{lgb.Booster} (the same `model` object that was passed as input, as invisible).
}
\description{
If a LightGBM model object was produced with argument `serializable=FALSE`, the R object will not
be serializable (e.g. cannot save and load with \code{saveRDS} and \code{readRDS}) as it will lack the raw bytes
needed to reconstruct its underlying C++ object. This function can be used to forcibly produce those serialized
raw bytes and make the object serializable. Note that the object will be modified in-place.

             \emph{New in version 4.0.0}
}
\seealso{
\link{lgb.restore_handle}, \link{lgb.drop_serialized}.
}
