% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-dtm.R
\name{dtm_tin}
\alias{dtm_tin}
\alias{tin}
\title{Spatial Interpolation Algorithm}
\usage{
tin(..., extrapolate = knnidw(3, 1, 50))
}
\arguments{
\item{...}{unused}

\item{extrapolate}{There are usually a few points outside the convex hull, determined by the ground
points at the very edge of the dataset, that cannot be interpolated with a triangulation.
Extrapolation is done using \link{knnidw} by default.}
}
\description{
This function is made to be used in \link{rasterize_terrain} or \link{normalize_height}. It
implements an algorithm for spatial interpolation. Spatial interpolation is based on a Delaunay
triangulation, which performs a linear interpolation within each triangle. There are usually a
few points outside the convex hull, determined by the ground points at the very edge of the dataset,
that cannot be interpolated with a triangulation. Extrapolation can be performed with another algorithm.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile, filter = "-inside 273450 5274350 273550 5274450")

#plot(las)

dtm = rasterize_terrain(las, algorithm = tin())

#plot(dtm)
#plot_dtm3d(dtm)
}
\seealso{
Other dtm algorithms: 
\code{\link{dtm_idw}},
\code{\link{dtm_kriging}}
}
\concept{dtm algorithms}
