% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.s3.R
\name{plot.lasmetrics3d}
\alias{plot.lasmetrics3d}
\title{Plot voxelized LiDAR data}
\usage{
\method{plot}{lasmetrics3d}(x, y, ...)
}
\arguments{
\item{x}{An object of the class \code{'lasmetrics3d'}}

\item{y}{Unused (inherited from R base)}

\item{\dots}{Supplementary parameters for \link[lidR:plot]{plot}. The function internally uses the
same plot function than LAS objects.}
}
\description{
This function implements a 3D plot method for 'lasmetrics3d' objects
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

voxels = voxel_metrics(lidar, list(Imean = mean(Intensity)), res = 5)
plot(voxels, color = "Imean", colorPalette = heat.colors(50), trim=60)
}
