% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{deprecated}
\alias{deprecated}
\alias{lascheck}
\alias{lasclip}
\alias{lasclipRectangle}
\alias{lasclipPolygon}
\alias{lasclipCircle}
\alias{lasdetectshape}
\alias{lasfilter}
\alias{lasfilterfirst}
\alias{lasfilterfirstlast}
\alias{lasfilterfirstofmany}
\alias{lasfilterground}
\alias{lasfilterlast}
\alias{lasfilternth}
\alias{lasfiltersingle}
\alias{lasfilterdecimate}
\alias{lasfilterduplicates}
\alias{lasfiltersurfacepoints}
\alias{lasground}
\alias{laspulse}
\alias{lasflightline}
\alias{lasscanline}
\alias{lasmergespatial}
\alias{lasnormalize}
\alias{lasunnormalize}
\alias{lasrangecorrection}
\alias{lasrescale}
\alias{lasreoffset}
\alias{lassmooth}
\alias{lasunsmooth}
\alias{lassnags}
\alias{lastransform}
\alias{lastrees}
\alias{lasadddata}
\alias{lasaddextrabytes}
\alias{lasaddextrabytes_manual}
\alias{lasremoveextrabytes}
\alias{lasvoxelize}
\alias{sensor_tracking}
\alias{tree_detection}
\alias{tree_hulls}
\title{Deprecated functions in lidR}
\usage{
lascheck(las)

lasclip(las, geometry, ...)

lasclipRectangle(las, xleft, ybottom, xright, ytop, ...)

lasclipPolygon(las, xpoly, ypoly, ...)

lasclipCircle(las, xcenter, ycenter, radius, ...)

lasdetectshape(las, algorithm, attribute = "Shape", filter = NULL)

lasfilter(las, ...)

lasfilterfirst(las)

lasfilterfirstlast(las)

lasfilterfirstofmany(las)

lasfilterground(las)

lasfilterlast(las)

lasfilternth(las, n)

lasfiltersingle(las)

lasfilterdecimate(las, algorithm)

lasfilterduplicates(las)

lasfiltersurfacepoints(las, res)

lasground(las, algorithm, last_returns = TRUE)

laspulse(las)

lasflightline(las, dt = 30)

lasscanline(las)

lasmergespatial(las, source, attribute = NULL)

lasnormalize(
  las,
  algorithm,
  na.rm = FALSE,
  use_class = c(2L, 9L),
  ...,
  add_lasattribute = FALSE
)

lasunnormalize(las)

lasrangecorrection(
  las,
  sensor,
  Rs,
  f = 2.3,
  gpstime = "gpstime",
  elevation = "Z"
)

lasrescale(las, xscale, yscale, zscale)

lasreoffset(las, xoffset, yoffset, zoffset)

lassmooth(
  las,
  size,
  method = c("average", "gaussian"),
  shape = c("circle", "square"),
  sigma = size/6
)

lasunsmooth(las)

lassnags(las, algorithm, attribute = "snagCls")

lastransform(las, CRSobj)

lastrees(las, algorithm, attribute = "treeID", uniqueness = "incremental")

lasadddata(las, x, name)

lasaddextrabytes(las, x, name, desc)

lasaddextrabytes_manual(
  las,
  x,
  name,
  desc,
  type,
  offset = NULL,
  scale = NULL,
  NA_value = NULL
)

lasremoveextrabytes(las, name)

lasvoxelize(las, res)

sensor_tracking(
  las,
  interval = 0.5,
  pmin = 50,
  extra_check = TRUE,
  thin_pulse_with_time = 0.001
)

tree_detection(las, algorithm)

tree_hulls(
  las,
  type = c("convex", "concave", "bbox"),
  concavity = 3,
  length_threshold = 0,
  func = NULL,
  attribute = "treeID"
)
}
\arguments{
\item{las}{See the new functions that replace the old ones}

\item{geometry}{See the new functions that replace the old ones}

\item{...}{See the new functions that replace the old ones}

\item{xleft, ybottom, xright, ytop}{See the new functions that replace the old ones}

\item{xpoly, ypoly}{See the new functions that replace the old ones}

\item{xcenter, ycenter, radius}{See the new functions that replace the old ones}

\item{algorithm}{See the new functions that replace the old ones}

\item{attribute}{See the new functions that replace the old ones}

\item{filter}{See the new functions that replace the old ones}

\item{n, res, dt}{See the new functions that replace the old ones}

\item{last_returns}{See the new functions that replace the old ones}

\item{source}{See the new functions that replace the old ones}

\item{na.rm, use_class, add_lasattribute}{See the new functions that replace the old ones}

\item{sensor, Rs, f, gpstime, elevation}{See the new functions that replace the old ones}

\item{xscale, yscale, zscale, xoffset, yoffset, zoffset}{See the new functions that replace the old ones}

\item{size, method, shape, sigma}{See the new functions that replace the old ones}

\item{CRSobj}{See the new functions that replace the old ones}

\item{uniqueness}{See the new functions that replace the old ones}

\item{x, name, desc, type, offset, scale, NA_value}{See the new functions that replace the old ones}

\item{interval, pmin, extra_check, thin_pulse_with_time}{See the new functions that replace the old ones}

\item{concavity, length_threshold, func}{See the new functions that replace the old ones}
}
\description{
These functions are provided for compatibility with older versions of lidR but are deprecated
since lidR version 3. They will progressively print a message, throw a warning and eventually be
removed. The links below point to the documentation of the new names \cr\cr
\link[=add_attribute]{lasadd} \link[=las_check]{lascheck} \link[=clip]{lasclip}
\link[=segment_shapes]{lasdetectshape} \link[=filter_poi]{lasfilter}
\link[=filter_surfacepoints]{lasfiltersurfacepoints} \link[=retrieve_flightlines]{lasflightline}
\link[=classify_ground]{lasground} \link[=merge_spatial]{lasmergespatial}
\link[=normalize_height]{lasnormalize} \link[=retrieve_pulses]{laspulse}
\link[=normalize_intensity]{lasrangecorrection} \link[=retrieve_flightlines]{lasflightline}
\link[=las_reoffset]{lasreoffset} \link[=las_rescale]{lasrescale}
\link[=retrieve_scanlines]{lasscanlines} \link[=smooth_height]{lassmooth}
\link[=segment_snags]{lassnags}
\link[=segment_trees]{lastrees} \link[=voxelize_points]{lasvoxelize}
\link[=track_sensor]{sensor_tracking} \link[=find_trees]{tree_detection}
\link[=delineate_crowns]{tree_hull}
}
