% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_catalog_options.R
\name{catalog_options_tools}
\alias{catalog_options_tools}
\alias{opt_chunk_buffer}
\alias{opt_chunk_buffer<-}
\alias{opt_chunk_size}
\alias{opt_chunk_size<-}
\alias{opt_chunk_alignment}
\alias{opt_chunk_alignment<-}
\alias{opt_progress}
\alias{opt_progress<-}
\alias{opt_stop_early}
\alias{opt_stop_early<-}
\alias{opt_wall_to_wall}
\alias{opt_wall_to_wall<-}
\alias{opt_independent_files}
\alias{opt_independent_files<-}
\alias{opt_output_files}
\alias{opt_output_files<-}
\alias{opt_laz_compression}
\alias{opt_laz_compression<-}
\alias{opt_merge}
\alias{opt_merge<-}
\alias{opt_select}
\alias{opt_select<-}
\alias{opt_filter}
\alias{opt_filter<-}
\title{Get or set LAScatalog processing engine options}
\usage{
opt_chunk_buffer(ctg)

opt_chunk_buffer(ctg) <- value

opt_chunk_size(ctg)

opt_chunk_size(ctg) <- value

opt_chunk_alignment(ctg)

opt_chunk_alignment(ctg) <- value

opt_progress(ctg)

opt_progress(ctg) <- value

opt_stop_early(ctg)

opt_stop_early(ctg) <- value

opt_wall_to_wall(ctg)

opt_wall_to_wall(ctg) <- value

opt_independent_files(ctg)

opt_independent_files(ctg) <- value

opt_output_files(ctg)

opt_output_files(ctg) <- value

opt_laz_compression(ctg)

opt_laz_compression(ctg) <- value

opt_merge(ctg)

opt_merge(ctg) <- value

opt_select(ctg)

opt_select(ctg) <- value

opt_filter(ctg)

opt_filter(ctg) <- value
}
\arguments{
\item{ctg}{An object of class \link[=LAScatalog-class]{LAScatalog}}

\item{value}{An appropriate value depending on the expected input.}
}
\description{
The names of the options and their roles are documented in \link[=LAScatalog-class]{LAScatalog}.
The options are used by all the functions that support a \code{LAScatalog} as input.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
ctg = readLAScatalog(LASfile)

plot(ctg, chunk_pattern = TRUE)

opt_chunk_size(ctg) <- 150
plot(ctg, chunk_pattern = TRUE)

opt_chunk_buffer(ctg) <- 10
plot(ctg, chunk_pattern = TRUE)

opt_chunk_alignment(ctg) <- c(270,250)
plot(ctg, chunk_pattern = TRUE)

summary(ctg)

opt_output_files(ctg) <- "/path/to/folder/templated_filename_{XBOTTOM}_{ID}"
summary(ctg)
}
