% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_attribute.R
\name{add_attribute}
\alias{add_attribute}
\alias{add_lasattribute}
\alias{add_lasattribute_manual}
\alias{add_lasrgb}
\alias{remove_lasattribute}
\title{Add attributes into a LAS object}
\usage{
add_attribute(las, x, name)

add_lasattribute(las, x, name, desc)

add_lasattribute_manual(
  las,
  x,
  name,
  desc,
  type,
  offset = NULL,
  scale = NULL,
  NA_value = NULL
)

add_lasrgb(las, R, G, B)

remove_lasattribute(las, name)
}
\arguments{
\item{las}{An object of class \link[=LAS-class]{LAS}}

\item{x}{a vector that needs to be added in the LAS object. For \code{add_lasattribute*} it can
be missing (see details).}

\item{name}{character. The name of the extra bytes attribute to add in the file.}

\item{desc}{character. A short description of the extra bytes attribute to add in the file (32 characters).}

\item{type}{character. The data type of the extra bytes attribute. Can be \code{"uchar", "char", "ushort", 
"short", "uint", "int", "uint64", "int64", "float", "double"}.}

\item{scale, offset}{numeric. The scale and offset of the data. NULL if not relevant.}

\item{NA_value}{numeric or integer. NA is not a valid value in a las file. At time of writing it will
be replaced by this value that will be considered as NA. NULL if not relevant.}

\item{R, G, B}{integer. RGB values}
}
\value{
An object of class \link[=LAS-class]{LAS}
}
\description{
A \link[=LAS-class]{LAS} object represents a las file in R. According to the
\href{https://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS specifications}
a las file contains a core of defined attributes, such as XYZ coordinates, intensity, return number,
and so on, for each point. It is possible to add supplementary attributes.
}
\details{
Users cannot assign names that are the same as the names of the core attributes. These functions are 
dedicated to adding data that are not part of the LAS specification. For example, \code{add_lasattribute(las, x, "R")} will fail because \code{R} is a name reserved for the red channel of a .las file that contains RGB
attributes. Use \code{add_lasrgb} instead.
\describe{
\item{\code{add_attribute}}{Simply adds a new column in the data but does not update the header. Thus the LAS
object is not strictly valid. These data will be temporarily usable at the R level but will not
be written in a las file with \link{writeLAS}.}

\item{ \code{add_lasattribute}}{Does the same as \code{add_attribute} but automatically updates the header of
the LAS object. Thus, the LAS object is valid and the new data is considered as "extra bytes". This new
data will be written in a las file with \link{writeLAS}.}

\item{\code{add_lasattribute_manual}}{Allows the user to manually write all the extra bytes metadata.
This function is reserved for experienced users with a good knowledge of the LAS specifications.
The function does not perform tests to check the validity of the information.
When using \code{add_lasattribute} and \code{add_lasattribute_manual}, \code{x} can only be of type numeric,
(\code{integer} or \code{double}). It cannot be of type \code{character} or \code{logical} as these are
not supported by the LAS specifications. The types that are supported in lidR are types 0 to 10
(Table 24 on page 25 of the specification). Types greater than 10 are not supported.}

\item{\code{add_lasrgb}}{Adds 3 columns named RGB and updates the point format of the LAS object
for a format that supports RGB attributes. If the RGB values are ranging from 0 to 255 they are
automatically scaled on 16 bits.}
}
}
\examples{
LASfile <- system.file("extdata", "example.laz", package="rlas")
las <- readLAS(LASfile, select = "xyz")

print(las)
print(las@header)

x <- 1:30

las <- add_attribute(las, x, "mydata")
print(las)        # The las object has a new attribute called "mydata"
print(las@header) # But the header has not been updated. This new data will not be written

las <- add_lasattribute(las, x, "mydata2", "A new data")
print(las)        # The las object has a new attribute called "mydata2"
print(las@header) # The header has been updated. This new data will be written

# Optionally if the data is already in the LAS object you can update the header skipping the
# parameter x
las <- add_lasattribute(las, name = "mydata", desc = "Amplitude")
print(las@header)

# Remove an extra bytes attribute
las <- remove_lasattribute(las, "mydata2")
print(las)
print(las@header)

las <- remove_lasattribute(las, "mydata")
print(las)
print(las@header)
}
