% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-shp.r
\name{shape_detection}
\alias{shape_detection}
\alias{shp_plane}
\alias{shp_hplane}
\alias{shp_line}
\title{Algorithms for shape detection of the local point neighborhood}
\usage{
shp_plane(th1 = 25, th2 = 6, k = 8)

shp_hplane(th1 = 25, th2 = 6, th3 = 0.98, k = 8)

shp_line(th1 = 10, k = 8)
}
\arguments{
\item{th1, th2, th3}{numeric. Threshold values (see details)}

\item{k}{integer. Number of neighbours used to estimate the neighborhood.}
}
\description{
These functions are made to be used in \link{lasdetectshape}. They implement algorithms for local
neighborhood shape estimation.
}
\details{
In the following, \eqn{a1, a2, a3} denote the eigenvalues of the covariance matrix of the neighbouring
points in ascending order. \eqn{th1, th2, th3} denote a set of threshold values. Points are labelled
\code{TRUE} if they meet the following criteria. \code{FALSE} otherwise.\cr
\describe{
\item{shp_plane}{Detection of plans based on criteria defined by Limberger & Oliveira (2015) (see references).
A point is labelled TRUE if the neighborhood is approximately planar, that is: \deqn{a2 > (th1*a1) and (th2*a2) > a3}}
\item{shp_hplane}{The same as 'plane' but with an extra test on the orientation of the Z vector
of the principal components to test the horizontality of the surface.  \deqn{a2 > (th1*a1) and (th2*a2) > a3 and |Z| > th3}
In theory |Z| should be exactly equal to 1. In practice 0.98 or 0.99 should be fine}
\item{shp_line}{Detection of lines inspired by the Limberger & Oliveira (2015) criterion. A point is
labelled TRUE if the neighborhood is approximately linear, that is: \deqn{th1*a2 < a3 and th1*a1 < a3}}
}
}
\references{
Limberger, F. A., & Oliveira, M. M. (2015). Real-time detection of planar regions in unorganized
point clouds. Pattern Recognition, 48(6), 2043–2053. https://doi.org/10.1016/j.patcog.2014.12.020\cr\cr
}
