% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-spi.r
\name{kriging}
\alias{kriging}
\title{Spatial Interpolation Algorithm}
\usage{
kriging(model = gstat::vgm(0.59, "Sph", 874), k = 10L)
}
\arguments{
\item{model}{A variogram model computed with \link[gstat:vgm]{vgm}. If NULL it performs an ordinary
or weighted least squares prediction.}

\item{k}{numeric. Number of k-nearest neighbours. Default 10.}
}
\description{
This function is made to be used in \link{grid_terrain} or \link{lasground}. It implements an algorithm
for spatial interpolation. Spatial interpolation is based on universal kriging using the \link[gstat:krige]{krige}
function from \code{gstat}. This method combines the KNN approach with the kriging approach. For each
point of interest it kriges the terrain using the k-nearest neighbour ground points. This method
is more difficult to manipulate but it is also the most advanced method for interpolating spatial data.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile)

# plot(las)

dtm = grid_terrain(las, algorithm = kriging())

plot(dtm, col = terrain.colors(50))
plot_dtm3d(dtm)
}
\seealso{
Other spatial interpolation algorithms: 
\code{\link{knnidw}()},
\code{\link{tin}()}
}
\concept{spatial interpolation algorithms}
