% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasmetrics.r
\name{lasmetrics}
\alias{lasmetrics}
\title{Compute metrics for a cloud of points}
\usage{
lasmetrics(obj, func)
}
\arguments{
\item{obj}{An object of class \code{LAS}}

\item{func}{formula. An expression to be applied to the point cloud (see example)}
}
\value{
It returns a \code{list} containing the metrics
}
\description{
\code{lasmetrics} computes a series of user-defined descriptive statistics for a LiDAR dataset.
See \link[lidR:grid_metrics]{grid_metrics} to compute metrics on a grid. Basically there are
no predefined metrics. Users must write their own functions to create metrics (see example).
The following existing functions can serve as a guide to help users compute their own metrics:
\itemize{
\item{\link[lidR:stdmetrics]{stdmetrics}}
\item{\link[lidR:entropy]{entropy}}
\item{\link[lidR:VCI]{VCI}}
\item{\link[lidR:LAD]{LAD}}
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

lasmetrics(lidar, ~max(Z))
lasmetrics(lidar, ~mean(Intensity))

# Define your own new metrics
myMetrics = function(z, i)
{
  metrics = list(
     zwimean = sum(z*i)/sum(i), # Mean elevation weighted by intensities
     zimean  = mean(z*i),       # Mean products of z by intensity
     zsqmean = sqrt(mean(z^2))  # Quadratic mean
   )

   return(metrics)
}

metrics = lasmetrics(lidar, ~myMetrics(Z, Intensity))

# Predefined metrics
lasmetrics(lidar, .stdmetrics)
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[lidR:stdmetrics]{stdmetrics}
\link[lidR:entropy]{entropy}
\link[lidR:VCI]{VCI}
\link[lidR:LAD]{LAD}
}
