% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasfilterduplicates.r
\name{lasfilterduplicates}
\alias{lasfilterduplicates}
\title{Filter duplicated points}
\usage{
lasfilterduplicates(las)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}
}
\value{
If the input is a \code{LAS} object, returns a \code{LAS} object. If the input is a
\code{LAScatalog}, returns a \code{LAScatalog}.
}
\description{
Filter points that appear more than once in the point cloud according to their X Y Z coordinates
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} (in bold). For more details see the
\link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk size}: How much data is loaded at once.
\item chunk buffer: This function guarantee a strict wall-to-wall continuous output. The \code{buffer}
option is not considered.
\item \strong{chunk alignment}: Align the processed chunks.
\item \strong{cores}: How many cores are used. More cores means more data is loaded at once.
\item \strong{progress}: Displays a progression estimation.
\item \strong{output_files*}: Mandatory because the output is likely to be too big to be returned
in R and needs to be written in las/laz files. Supported templates are \code{XLEFT}, \code{XRIGHT},
\code{YBOTTOM}, \code{YTOP}, \code{XCENTER}, \code{YCENTER} \code{ID} and, if chunk is size equal
to 0 (processing by file), \code{ORIGINALFILENAME}.
\item \strong{laz_compression}: write \code{las} or \code{laz} files
\item select: The function will write files equivalent to the original ones. Thus \code{select = "*"}
and cannot be changed.
\item \strong{filter}: Read only points of interest.
}
}

\seealso{
Other lasfilters: \code{\link{lasfiltersurfacepoints}},
  \code{\link{lasfilters}}, \code{\link{lasfilter}}
}
\concept{lasfilters}
