% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasdecimate.r
\name{lasdecimate}
\alias{lasdecimate}
\title{Thin LiDAR data}
\usage{
lasdecimate(.las, density, homogenize = TRUE, res = 5)
}
\arguments{
\item{.las}{An object of the class \code{LAS}}

\item{density}{numeric. The expected density}

\item{homogenize}{logical. If \code{TRUE}, the algorithm tries to homogenize the pulse density to provide a uniform
dataset. If \code{FALSE} the algorithm will reach the pulse density over the whole area.}

\item{res}{numeric. Cell size to compute the pulse density.}
}
\value{
It returns a \code{LAS} object.
}
\description{
Thin LIDAR data randomly removes a given proportion of pulses to reach specific pulse densities
}
\details{
\code{lasdecimate} is designed to produce output datasets that have uniform pulse densities
throughout the coverage area. For each cell, the proportion of pulses that will
be retained is computed using the actual pulse density and the desired pulse
density. If the required pulse density is greater than the actual pulse density it returns
an unchanged set of points (it cannot increase the pulse density). If \code{homogenize = FALSE} is selected, it
randomly removes pulses to reach the required pulse density over the whole area
(see \code{\link[lidR:area]{area}}). The cell size must be large enough
to compute a coherent local pulse density i.e., in a 2 pulse/m^2 dataset, 25 square meters would be
feasible; however, an extent too small to thin (e.g. <1 square meter) would not be feasible because
pulse density does not have meaning at this scale.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile, select = "xyztP")

# By default the method is homogenize = TRUE
thinned = lidar \%>\% lasdecimate(1, res = 5)
lidar   \%>\% grid_density \%>\% plot
thinned \%>\% grid_density \%>\% plot

# Method homogenize = FALSE enables a global pulse density to be reached
thinned = lidar \%>\% lasdecimate(1, homogenize = FALSE)
thinned \%>\% summary
thinned \%>\% grid_density \%>\% plot
}
