/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/TaskInformation.h>
#include <so/private/TaskInformation.h>

so_TaskInformation *so_TaskInformation_new()
{
	so_TaskInformation *object = calloc(sizeof(so_TaskInformation), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_TaskInformation *so_TaskInformation_copy(so_TaskInformation *self)
{
	so_TaskInformation *dest = so_TaskInformation_new();
	if (dest) {
		if (self->num_Message) {
			dest->Message = calloc(self->num_Message * sizeof(so_Message *), 1);
			if (!dest->Message) {
				so_TaskInformation_free(dest);
				return NULL;
			}
			dest->num_Message = self->num_Message;
			for (int i = 0; i < self->num_Message; i++) {
				dest->Message[i] = so_Message_copy(self->Message[i]);
				if (!dest->Message[i]) {
					so_TaskInformation_free(dest);
					return NULL;
				}
			}
		}
		if (self->num_OutputFilePath) {
			dest->OutputFilePath = calloc(self->num_OutputFilePath * sizeof(so_ExternalFile *), 1);
			if (!dest->OutputFilePath) {
				so_TaskInformation_free(dest);
				return NULL;
			}
			dest->num_OutputFilePath = self->num_OutputFilePath;
			for (int i = 0; i < self->num_OutputFilePath; i++) {
				dest->OutputFilePath[i] = so_ExternalFile_copy(self->OutputFilePath[i]);
				if (!dest->OutputFilePath[i]) {
					so_TaskInformation_free(dest);
					return NULL;
				}
			}
		}
		if (self->RunTime) {
			dest->RunTime_number = self->RunTime_number;
			dest->RunTime = &(dest->RunTime_number);
		}
		if (self->NumberChains) {
			dest->NumberChains_number = self->NumberChains_number;
			dest->NumberChains = &(dest->NumberChains_number);
		}
		if (self->NumberIterations) {
			dest->NumberIterations_number = self->NumberIterations_number;
			dest->NumberIterations = &(dest->NumberIterations_number);
		}
	}

	return dest;
}

void so_TaskInformation_free(so_TaskInformation *self)
{
	if (self) {
		for(int i = 0; i < self->num_Message; i++) {
			so_Message_unref(self->Message[i]);
		}
		free(self->Message);
		for(int i = 0; i < self->num_OutputFilePath; i++) {
			so_ExternalFile_unref(self->OutputFilePath[i]);
		}
		free(self->OutputFilePath);
		free(self);
	}
}

void so_TaskInformation_ref(so_TaskInformation *self)
{
	self->reference_count++;
}

void so_TaskInformation_unref(so_TaskInformation *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_TaskInformation_free(self);
		}
	}
}

so_Message *so_TaskInformation_get_Message(so_TaskInformation *self, int number)
{
	return self->Message[number];
}

so_ExternalFile *so_TaskInformation_get_OutputFilePath(so_TaskInformation *self, int number)
{
	return self->OutputFilePath[number];
}

double *so_TaskInformation_get_RunTime(so_TaskInformation *self)
{
	return self->RunTime;
}

int *so_TaskInformation_get_NumberChains(so_TaskInformation *self)
{
	return self->NumberChains;
}

int *so_TaskInformation_get_NumberIterations(so_TaskInformation *self)
{
	return self->NumberIterations;
}

int so_TaskInformation_get_number_of_Message(so_TaskInformation *self)
{
	return self->num_Message;
}

int so_TaskInformation_get_number_of_OutputFilePath(so_TaskInformation *self)
{
	return self->num_OutputFilePath;
}

void so_TaskInformation_set_RunTime(so_TaskInformation *self, double *value)
{
	if (value) {
		self->RunTime_number = *value;
		self->RunTime = &(self->RunTime_number);
	} else {
		self->RunTime = value;
	}
}

void so_TaskInformation_set_NumberChains(so_TaskInformation *self, int *value)
{
	if (value) {
		self->NumberChains_number = *value;
		self->NumberChains = &(self->NumberChains_number);
	} else {
		self->NumberChains = value;
	}
}

void so_TaskInformation_set_NumberIterations(so_TaskInformation *self, int *value)
{
	if (value) {
		self->NumberIterations_number = *value;
		self->NumberIterations = &(self->NumberIterations_number);
	} else {
		self->NumberIterations = value;
	}
}

so_Message *so_TaskInformation_create_Message(so_TaskInformation *self)
{
	so_Message *obj = so_Message_new();
	if (obj) {
		so_Message **newblock = realloc(self->Message, (self->num_Message + 1) * sizeof(so_Message *));
		if (newblock) {
			self->Message = newblock;
			self->Message[self->num_Message] = obj;
			self->num_Message++;
		} else {
			so_Message_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

so_ExternalFile *so_TaskInformation_create_OutputFilePath(so_TaskInformation *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("OutputFilePath");
	if (obj) {
		so_ExternalFile **newblock = realloc(self->OutputFilePath, (self->num_OutputFilePath + 1) * sizeof(so_ExternalFile *));
		if (newblock) {
			self->OutputFilePath = newblock;
			self->OutputFilePath[self->num_OutputFilePath] = obj;
			self->num_OutputFilePath++;
		} else {
			so_ExternalFile_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

int so_TaskInformation_add_Message(so_TaskInformation *self, so_Message *child)
{
	so_Message **new_array = realloc(self->Message, (self->num_Message + 1) * sizeof(so_Message *));
	if (!new_array) {
		return 1;
	}
	self->Message = new_array;
	self->Message[self->num_Message] = child;
	self->num_Message++;
	return 0;
}

int so_TaskInformation_remove_Message(so_TaskInformation *self, int index)
{
	int size = self->num_Message;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->Message);
		self->Message = NULL;
		return 0;
	}
	so_Message *final = self->Message[size - 1];
	so_Message *remove = self->Message[index];
	so_Message **new_array = realloc(self->Message, (self->num_Message - 1) * sizeof(so_Message *));
	if (!new_array) {
		return 1;
	}
	self->num_Message--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->Message[i] = self->Message[i + 1];
	}
	self->Message[size - 2] = final;
	so_Message_unref(remove);
	return 0;
}

int so_TaskInformation_add_OutputFilePath(so_TaskInformation *self, so_ExternalFile *child)
{
	so_ExternalFile **new_array = realloc(self->OutputFilePath, (self->num_OutputFilePath + 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->OutputFilePath = new_array;
	self->OutputFilePath[self->num_OutputFilePath] = child;
	self->num_OutputFilePath++;
	return 0;
}

int so_TaskInformation_remove_OutputFilePath(so_TaskInformation *self, int index)
{
	int size = self->num_OutputFilePath;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->OutputFilePath);
		self->OutputFilePath = NULL;
		return 0;
	}
	so_ExternalFile *final = self->OutputFilePath[size - 1];
	so_ExternalFile *remove = self->OutputFilePath[index];
	so_ExternalFile **new_array = realloc(self->OutputFilePath, (self->num_OutputFilePath - 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->num_OutputFilePath--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->OutputFilePath[i] = self->OutputFilePath[i + 1];
	}
	self->OutputFilePath[size - 2] = final;
	so_ExternalFile_unref(remove);
	return 0;
}

int so_TaskInformation_xml(so_TaskInformation *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->Message || self->OutputFilePath || self->RunTime || self->NumberChains || self->NumberIterations) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "TaskInformation");
		if (rc < 0) return 1;
		if (self->Message) {
			for (int i = 0; i < self->num_Message; i++) {
				rc = so_Message_xml(self->Message[i], writer);
				if (rc != 0) return 1;
			}
		}
		if (self->OutputFilePath) {
			for (int i = 0; i < self->num_OutputFilePath; i++) {
				rc = so_ExternalFile_xml(self->OutputFilePath[i], writer, "OutputFilePath");
				if (rc != 0) return 1;
			}
		}
		if (self->RunTime) {
			char *number_string = pharmml_double_to_string(self->RunTime_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "RunTime", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->NumberChains) {
			char *number_string = pharmml_int_to_string(self->NumberChains_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "NumberChains", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		if (self->NumberIterations) {
			char *number_string = pharmml_int_to_string(self->NumberIterations_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "NumberIterations", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_TaskInformation_start_element(so_TaskInformation *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_Message) {
		int fail = so_Message_start_element(self->Message[self->num_Message - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_OutputFilePath) {
		int fail = so_ExternalFile_start_element(self->OutputFilePath[self->num_OutputFilePath - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "Message") == 0) {
		so_Message *Message = so_Message_new();
		if (!Message) {
			return 1;
		}
		int fail = so_Message_init_attributes(Message, nb_attributes, attributes);
		if (fail) {
			so_Message_free(Message);
			return 1;
		}
		fail = so_TaskInformation_add_Message(self, Message);
		if (fail) {
			so_Message_free(Message);
			return 1;
		}
		self->in_Message = 1;
	} else if (strcmp(localname, "OutputFilePath") == 0) {
		so_ExternalFile *OutputFilePath = so_ExternalFile_new("OutputFilePath");
		if (!OutputFilePath) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(OutputFilePath, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(OutputFilePath);
			return 1;
		}
		fail = so_TaskInformation_add_OutputFilePath(self, OutputFilePath);
		if (fail) {
			so_ExternalFile_free(OutputFilePath);
			return 1;
		}
		self->in_OutputFilePath = 1;
	} else if (strcmp(localname, "RunTime") == 0) {
		self->in_RunTime = 1;
	} else if (strcmp(localname, "NumberChains") == 0) {
		self->in_NumberChains = 1;
	} else if (strcmp(localname, "NumberIterations") == 0) {
		self->in_NumberIterations = 1;
	}
	return 0;
}

void so_TaskInformation_end_element(so_TaskInformation *self, const char *localname)
{
	if (strcmp(localname, "Message") == 0 && self->in_Message) {
		self->in_Message = 0;
	} else if (strcmp(localname, "OutputFilePath") == 0 && self->in_OutputFilePath) {
		self->in_OutputFilePath = 0;
	} else if (strcmp(localname, "RunTime") == 0 && self->in_RunTime) {
		self->in_RunTime = 0;
	} else if (strcmp(localname, "NumberChains") == 0 && self->in_NumberChains) {
		self->in_NumberChains = 0;
	} else if (strcmp(localname, "NumberIterations") == 0 && self->in_NumberIterations) {
		self->in_NumberIterations = 0;
	} else if (self->in_Message) {
		so_Message_end_element(self->Message[self->num_Message - 1], localname);
	} else if (self->in_OutputFilePath) {
		so_ExternalFile_end_element(self->OutputFilePath[self->num_OutputFilePath - 1], localname);
	}
}

int so_TaskInformation_characters(so_TaskInformation *self, const char *ch, int len)
{
	if (self->in_Message) {
		int fail = so_Message_characters(self->Message[self->num_Message - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_OutputFilePath) {
		int fail = so_ExternalFile_characters(self->OutputFilePath[self->num_OutputFilePath - 1], ch, len);
		if (fail) return 1;
	} else if (self->in_RunTime) {
		self->RunTime_number = pharmml_string_to_double(ch);
		self->RunTime = &(self->RunTime_number);
	} else if (self->in_NumberChains) {
		self->NumberChains_number = pharmml_string_to_int(ch);
		self->NumberChains = &(self->NumberChains_number);
	} else if (self->in_NumberIterations) {
		self->NumberIterations_number = pharmml_string_to_int(ch);
		self->NumberIterations = &(self->NumberIterations_number);
	}
	return 0;
}
