# libsoc - Library to handle standardised output files
# Copyright (C) 2015 Rikard Nordgren
# 
# This file was autogenerated and should not be edited
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# his library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, see <http://www.gnu.org/licenses/>.

so_SO_new <- function() {
	obj = .Call("r_so_SO_new")
}

so_SO_copy <- function(self) {
	.Call("r_so_SO_copy", self)
}

so_SO_free <- function(self) {
	.Call("r_so_SO_free", self)
}

so_SO_ref <- function(self) {
	.Call("r_so_SO_ref", self)
}

so_SO_unref <- function(self) {
	.Call("r_so_SO_unref", self)
}

so_SO_get_id <- function(self) {
	.Call("r_so_SO_get_id", self)
}

so_SO_set_id <- function(self, value) {
	.Call("r_so_SO_set_id", self, value)
}

so_SO_get_metadataFile <- function(self) {
	.Call("r_so_SO_get_metadataFile", self)
}

so_SO_set_metadataFile <- function(self, value) {
	.Call("r_so_SO_set_metadataFile", self, value)
}

so_SO_get_Description <- function(self) {
	.Call("r_so_SO_get_Description", self)
}

so_SO_set_Description <- function(self, value) {
	.Call("r_so_SO_set_Description", self, value)
}

so_SO_get_PharmMLRef <- function(self) {
	.Call("r_so_SO_get_PharmMLRef", self)
}

so_SO_set_PharmMLRef <- function(self, value) {
	.Call("r_so_SO_set_PharmMLRef", self, value)
}

so_SO_create_PharmMLRef <- function(self) {
	.Call("r_so_SO_create_PharmMLRef", self)
}

so_SO_get_SOBlock <- function(self, number) {
	.Call("r_so_SO_get_SOBlock", self, number)
}

so_SO_get_number_of_SOBlock <- function(self) {
	.Call("r_so_SO_get_number_of_SOBlock", self)
}
so_SO_add_SOBlock <- function(self, value) {
	.Call("r_so_SO_add_SOBlock", self, value)
}
so_SO_remove_SOBlock <- function(self, index) {
	.Call("r_so_SO_remove_SOBlock", self, index)
}

so_SO_create_SOBlock <- function(self) {
	.Call("r_so_SO_create_SOBlock", self)
}

id_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_SO_get_id(.self$.cobj)
		} else {
			stopifnot(is.character(value), length(value) == 1)
			so_SO_set_id(.self$.cobj, value)
		}
	}
}

metadataFile_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_SO_get_metadataFile(.self$.cobj)
		} else {
			stopifnot(is.character(value), length(value) == 1)
			so_SO_set_metadataFile(.self$.cobj, value)
		}
	}
}

Description_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_SO_get_Description(.self$.cobj)
		} else {
			if (!is(value, "character")) {
				stop("object must be of type 'character'")
			}
			so_SO_set_Description(.self$.cobj, value)
		}
	}
}

PharmMLRef_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			child = so_SO_get_PharmMLRef(.self$.cobj)
			if (!isnull(child)) {
				so_PharmMLRef_ref(child)
				so_PharmMLRef$new(cobj=child)
			}
		} else {
			if (!is(value, "so_PharmMLRef")) {
				stop("object must be of type 'so_PharmMLRef'")
			}
			so_SO_set_PharmMLRef(.self$.cobj, value$.cobj)
			so_PharmMLRef_ref(value$.cobj)
		}
	}
}

SOBlock_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SO_get_number_of_SOBlock(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SO_get_SOBlock(.self$.cobj, i - 1L)
					a[[i]] = so_SOBlock$new(cobj=child)
					so_SOBlock_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

so_SO = setRefClass("so_SO",
	fields=list(
		id = id_acc,
		metadataFile = metadataFile_acc,
		Description = Description_acc,
		PharmMLRef = PharmMLRef_acc,
		SOBlock = SOBlock_acc,
		.cobj = "externalptr"
	),
	methods=list(
		copy = function() {
			copy = so_SO_copy(.self$.cobj)
			so_SO$new(cobj=copy)
		},
		initialize = function(cobj) {
			if (missing(cobj)) {
				.cobj <<- so_SO_new()
			} else {
				.cobj <<- cobj
			}
		},
		finalize = function() {
			so_SO_unref(.self$.cobj)
		},
		add_SOBlock = function(value) {
			so_SO_add_SOBlock(.self$.cobj, value$.cobj)
			invisible(so_SOBlock_ref(value$.cobj))
		},
		remove_SOBlock = function(value, index) {
			invisible(so_SO_remove_SOBlock(.self$.cobj, index))
		}
	)
)
