# libsoc - Library to handle standardised output files
# Copyright (C) 2015 Rikard Nordgren
# 
# This file was autogenerated and should not be edited
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# his library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, see <http://www.gnu.org/licenses/>.

so_RawResults_new <- function() {
	obj = .Call("r_so_RawResults_new")
}

so_RawResults_copy <- function(self) {
	.Call("r_so_RawResults_copy", self)
}

so_RawResults_free <- function(self) {
	.Call("r_so_RawResults_free", self)
}

so_RawResults_ref <- function(self) {
	.Call("r_so_RawResults_ref", self)
}

so_RawResults_unref <- function(self) {
	.Call("r_so_RawResults_unref", self)
}

so_RawResults_get_DataFile <- function(self, number) {
	.Call("r_so_RawResults_get_DataFile", self, number)
}

so_RawResults_get_number_of_DataFile <- function(self) {
	.Call("r_so_RawResults_get_number_of_DataFile", self)
}
so_RawResults_add_DataFile <- function(self, value) {
	.Call("r_so_RawResults_add_DataFile", self, value)
}
so_RawResults_remove_DataFile <- function(self, index) {
	.Call("r_so_RawResults_remove_DataFile", self, index)
}

so_RawResults_create_DataFile <- function(self) {
	.Call("r_so_RawResults_create_DataFile", self)
}

so_RawResults_get_GraphicsFile <- function(self, number) {
	.Call("r_so_RawResults_get_GraphicsFile", self, number)
}

so_RawResults_get_number_of_GraphicsFile <- function(self) {
	.Call("r_so_RawResults_get_number_of_GraphicsFile", self)
}
so_RawResults_add_GraphicsFile <- function(self, value) {
	.Call("r_so_RawResults_add_GraphicsFile", self, value)
}
so_RawResults_remove_GraphicsFile <- function(self, index) {
	.Call("r_so_RawResults_remove_GraphicsFile", self, index)
}

so_RawResults_create_GraphicsFile <- function(self) {
	.Call("r_so_RawResults_create_GraphicsFile", self)
}

DataFile_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_RawResults_get_number_of_DataFile(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_RawResults_get_DataFile(.self$.cobj, i - 1L)
					a[[i]] = child
				}
				return(a)
			}
		} else {
		}
	}
}

GraphicsFile_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_RawResults_get_number_of_GraphicsFile(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_RawResults_get_GraphicsFile(.self$.cobj, i - 1L)
					a[[i]] = so_ExternalFile$new(cobj=child)
					so_ExternalFile_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

so_RawResults = setRefClass("so_RawResults",
	fields=list(
		DataFile = DataFile_acc,
		GraphicsFile = GraphicsFile_acc,
		.cobj = "externalptr"
	),
	methods=list(
		copy = function() {
			copy = so_RawResults_copy(.self$.cobj)
			so_RawResults$new(cobj=copy)
		},
		initialize = function(cobj) {
			if (missing(cobj)) {
				.cobj <<- so_RawResults_new()
			} else {
				.cobj <<- cobj
			}
		},
		finalize = function() {
			so_RawResults_unref(.self$.cobj)
		},
		add_DataFile = function(value) {
			invisible(so_RawResults_add_DataFile(.self$.cobj, value))
		},
		remove_DataFile = function(value, index) {
			invisible(so_RawResults_remove_DataFile(.self$.cobj, index))
		},
		add_GraphicsFile = function(value) {
			so_RawResults_add_GraphicsFile(.self$.cobj, value$.cobj)
			invisible(so_ExternalFile_ref(value$.cobj))
		},
		remove_GraphicsFile = function(value, index) {
			invisible(so_RawResults_remove_GraphicsFile(.self$.cobj, index))
		}
	)
)
