/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_SIMULATIONBLOCK_H
#define _SO_SIMULATIONBLOCK_H

#include <so/SimulationSubType.h>
#include <so/ExternalFile.h>

/** \struct so_SimulationBlock
	 \brief A structure representing an SO/SOBlock/Simulation/SimulationBlock element
*/
typedef struct so_SimulationBlock so_SimulationBlock;

/** \memberof so_SimulationBlock
 * Create a new empty so_SimulationBlock structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_SimulationBlock_copy, so_SimulationBlock_free
 */
so_SimulationBlock *so_SimulationBlock_new();
/** \memberof so_SimulationBlock
 * Create a copy of a so_SimulationBlock structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_SimulationBlock_new
 */
so_SimulationBlock *so_SimulationBlock_copy(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Free all memory associated with a so_SimulationBlock structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_SimulationBlock_new
 */
void so_SimulationBlock_free(so_SimulationBlock *self);
void so_SimulationBlock_ref(so_SimulationBlock *self);
void so_SimulationBlock_unref(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the value of the replicate attribute
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the attribute value
 * \sa so_SimulationBlock_set_replicate
 */
int *so_SimulationBlock_get_replicate(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Set the value of the replicate attribute
 * \param self - pointer to a so_SimulationBlock
 * \param value - A pointer to the attribute value
 * \sa so_SimulationBlock_get_replicate
 */
void so_SimulationBlock_set_replicate(so_SimulationBlock *self, int *value);
/** \memberof so_SimulationBlock
 * Get the SimulatedProfiles element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the SimulatedProfiles element
 * \sa so_SimulationBlock_set_SimulatedProfiles
 */
so_SimulationSubType *so_SimulationBlock_get_SimulatedProfiles(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of SimulatedProfiles currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of SimulatedProfiless
 */
int so_SimulationBlock_get_number_of_SimulatedProfiles(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the IndivParameters element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the IndivParameters element
 * \sa so_SimulationBlock_set_IndivParameters
 */
so_SimulationSubType *so_SimulationBlock_get_IndivParameters(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of IndivParameters currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of IndivParameterss
 */
int so_SimulationBlock_get_number_of_IndivParameters(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the RandomEffects element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the RandomEffects element
 * \sa so_SimulationBlock_set_RandomEffects
 */
so_SimulationSubType *so_SimulationBlock_get_RandomEffects(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of RandomEffects currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of RandomEffectss
 */
int so_SimulationBlock_get_number_of_RandomEffects(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the Covariates element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the Covariates element
 * \sa so_SimulationBlock_set_Covariates
 */
so_SimulationSubType *so_SimulationBlock_get_Covariates(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of Covariates currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of Covariatess
 */
int so_SimulationBlock_get_number_of_Covariates(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the Regressors element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the Regressors element
 * \sa so_SimulationBlock_set_Regressors
 */
so_SimulationSubType *so_SimulationBlock_get_Regressors(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of Regressors currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of Regressorss
 */
int so_SimulationBlock_get_number_of_Regressors(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the PopulationParameters element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the PopulationParameters element
 * \sa so_SimulationBlock_set_PopulationParameters
 */
so_SimulationSubType *so_SimulationBlock_get_PopulationParameters(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of PopulationParameters currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of PopulationParameterss
 */
int so_SimulationBlock_get_number_of_PopulationParameters(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the Dosing element
 * \param self - pointer to a so_SimulationBlock
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the Dosing element
 * \sa so_SimulationBlock_set_Dosing
 */
so_SimulationSubType *so_SimulationBlock_get_Dosing(so_SimulationBlock *self, int number);
/** \memberof so_SimulationBlock
 * Get the number of Dosing currently contained in the SimulationBlock structure
 * \param self - pointer to a so_SimulationBlock
 * \return The number of Dosings
 */
int so_SimulationBlock_get_number_of_Dosing(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Get the RawResultsFile element
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the structure representing the RawResultsFile element
 * \sa so_SimulationBlock_set_RawResultsFile
 */
so_ExternalFile *so_SimulationBlock_get_RawResultsFile(so_SimulationBlock *self);
/** \memberof so_SimulationBlock
 * Set the RawResultsFile element
 * \param self - pointer to a so_SimulationBlock
 * \param value - A pointer to a \a so_ExternalFile to set.
 * \sa so_SimulationBlock_get_RawResultsFile
 */
void so_SimulationBlock_set_RawResultsFile(so_SimulationBlock *self, so_ExternalFile *value);
/** \memberof so_SimulationBlock
 * Create a new SimulatedProfiles element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_SimulatedProfiles(so_SimulationBlock *self);
int so_SimulationBlock_add_SimulatedProfiles(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_SimulatedProfiles(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new IndivParameters element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_IndivParameters(so_SimulationBlock *self);
int so_SimulationBlock_add_IndivParameters(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_IndivParameters(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new RandomEffects element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_RandomEffects(so_SimulationBlock *self);
int so_SimulationBlock_add_RandomEffects(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_RandomEffects(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new Covariates element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_Covariates(so_SimulationBlock *self);
int so_SimulationBlock_add_Covariates(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_Covariates(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new Regressors element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_Regressors(so_SimulationBlock *self);
int so_SimulationBlock_add_Regressors(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_Regressors(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new PopulationParameters element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_PopulationParameters(so_SimulationBlock *self);
int so_SimulationBlock_add_PopulationParameters(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_PopulationParameters(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new Dosing element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SimulationSubType *so_SimulationBlock_create_Dosing(so_SimulationBlock *self);
int so_SimulationBlock_add_Dosing(so_SimulationBlock *self, so_SimulationSubType *child);
int so_SimulationBlock_remove_Dosing(so_SimulationBlock *self, int index);
/** \memberof so_SimulationBlock
 * Create a new RawResultsFile element and insert it into the so_SimulationBlock
 * \param self - pointer to a so_SimulationBlock
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_ExternalFile *so_SimulationBlock_create_RawResultsFile(so_SimulationBlock *self);

#endif
