/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_RAWRESULTS_H
#define _SO_RAWRESULTS_H

#include <so/Table.h>
#include <so/ExternalFile.h>

/** \struct so_RawResults
	 \brief A structure representing an SO/SOBlock/RawResults element
*/
typedef struct so_RawResults so_RawResults;

/** \memberof so_RawResults
 * Create a new empty so_RawResults structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_RawResults_copy, so_RawResults_free
 */
so_RawResults *so_RawResults_new();
/** \memberof so_RawResults
 * Create a copy of a so_RawResults structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_RawResults_new
 */
so_RawResults *so_RawResults_copy(so_RawResults *self);
/** \memberof so_RawResults
 * Free all memory associated with a so_RawResults structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_RawResults_new
 */
void so_RawResults_free(so_RawResults *self);
void so_RawResults_ref(so_RawResults *self);
void so_RawResults_unref(so_RawResults *self);
/** \memberof so_RawResults
 * Get the DataFile element
 * \param self - pointer to a so_RawResults
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the DataFile element
 * \sa so_RawResults_set_DataFile
 */
so_Table *so_RawResults_get_DataFile(so_RawResults *self, int number);
/** \memberof so_RawResults
 * Get the number of DataFile currently contained in the RawResults structure
 * \param self - pointer to a so_RawResults
 * \return The number of DataFiles
 */
int so_RawResults_get_number_of_DataFile(so_RawResults *self);
/** \memberof so_RawResults
 * Get the GraphicsFile element
 * \param self - pointer to a so_RawResults
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the GraphicsFile element
 * \sa so_RawResults_set_GraphicsFile
 */
so_ExternalFile *so_RawResults_get_GraphicsFile(so_RawResults *self, int number);
/** \memberof so_RawResults
 * Get the number of GraphicsFile currently contained in the RawResults structure
 * \param self - pointer to a so_RawResults
 * \return The number of GraphicsFiles
 */
int so_RawResults_get_number_of_GraphicsFile(so_RawResults *self);
/** \memberof so_RawResults
 * Create a new DataFile element and insert it into the so_RawResults
 * \param self - pointer to a so_RawResults
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_RawResults_create_DataFile(so_RawResults *self);
int so_RawResults_add_DataFile(so_RawResults *self, so_Table *child);
int so_RawResults_remove_DataFile(so_RawResults *self, int index);
/** \memberof so_RawResults
 * Create a new GraphicsFile element and insert it into the so_RawResults
 * \param self - pointer to a so_RawResults
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_ExternalFile *so_RawResults_create_GraphicsFile(so_RawResults *self);
int so_RawResults_add_GraphicsFile(so_RawResults *self, so_ExternalFile *child);
int so_RawResults_remove_GraphicsFile(so_RawResults *self, int index);

#endif
