/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRECISIONPOPULATIONESTIMATES_H
#define _SO_PRECISIONPOPULATIONESTIMATES_H

#include <so/MLE.h>
#include <so/Bayesian_PPE.h>
#include <so/OtherMethod_PPE.h>

/** \struct so_PrecisionPopulationEstimates
	 \brief A structure representing an SO/SOBlock/Estimation/PrecisionPopulationEstimates element
*/
typedef struct so_PrecisionPopulationEstimates so_PrecisionPopulationEstimates;

/** \memberof so_PrecisionPopulationEstimates
 * Create a new empty so_PrecisionPopulationEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PrecisionPopulationEstimates_copy, so_PrecisionPopulationEstimates_free
 */
so_PrecisionPopulationEstimates *so_PrecisionPopulationEstimates_new();
/** \memberof so_PrecisionPopulationEstimates
 * Create a copy of a so_PrecisionPopulationEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PrecisionPopulationEstimates_new
 */
so_PrecisionPopulationEstimates *so_PrecisionPopulationEstimates_copy(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Free all memory associated with a so_PrecisionPopulationEstimates structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_PrecisionPopulationEstimates_new
 */
void so_PrecisionPopulationEstimates_free(so_PrecisionPopulationEstimates *self);
void so_PrecisionPopulationEstimates_ref(so_PrecisionPopulationEstimates *self);
void so_PrecisionPopulationEstimates_unref(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Get the MLE element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the structure representing the MLE element
 * \sa so_PrecisionPopulationEstimates_set_MLE
 */
so_MLE *so_PrecisionPopulationEstimates_get_MLE(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Get the Bayesian element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the structure representing the Bayesian element
 * \sa so_PrecisionPopulationEstimates_set_Bayesian
 */
so_Bayesian_PPE *so_PrecisionPopulationEstimates_get_Bayesian(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Get the OtherMethod element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the structure representing the OtherMethod element
 * \sa so_PrecisionPopulationEstimates_set_OtherMethod
 */
so_OtherMethod_PPE *so_PrecisionPopulationEstimates_get_OtherMethod(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Set the MLE element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \param value - A pointer to a \a so_MLE to set.
 * \sa so_PrecisionPopulationEstimates_get_MLE
 */
void so_PrecisionPopulationEstimates_set_MLE(so_PrecisionPopulationEstimates *self, so_MLE *value);
/** \memberof so_PrecisionPopulationEstimates
 * Set the Bayesian element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \param value - A pointer to a \a so_Bayesian_PPE to set.
 * \sa so_PrecisionPopulationEstimates_get_Bayesian
 */
void so_PrecisionPopulationEstimates_set_Bayesian(so_PrecisionPopulationEstimates *self, so_Bayesian_PPE *value);
/** \memberof so_PrecisionPopulationEstimates
 * Set the OtherMethod element
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \param value - A pointer to a \a so_OtherMethod_PPE to set.
 * \sa so_PrecisionPopulationEstimates_get_OtherMethod
 */
void so_PrecisionPopulationEstimates_set_OtherMethod(so_PrecisionPopulationEstimates *self, so_OtherMethod_PPE *value);
/** \memberof so_PrecisionPopulationEstimates
 * Create a new MLE element and insert it into the so_PrecisionPopulationEstimates
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_MLE *so_PrecisionPopulationEstimates_create_MLE(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Create a new Bayesian element and insert it into the so_PrecisionPopulationEstimates
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Bayesian_PPE *so_PrecisionPopulationEstimates_create_Bayesian(so_PrecisionPopulationEstimates *self);
/** \memberof so_PrecisionPopulationEstimates
 * Create a new OtherMethod element and insert it into the so_PrecisionPopulationEstimates
 * \param self - pointer to a so_PrecisionPopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_OtherMethod_PPE *so_PrecisionPopulationEstimates_create_OtherMethod(so_PrecisionPopulationEstimates *self);

#endif
