/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_POPULATIONESTIMATES_H
#define _SO_POPULATIONESTIMATES_H

#include <so/Table.h>
#include <so/Bayesian.h>
#include <so/OtherMethod.h>

/** \struct so_PopulationEstimates
	 \brief A structure representing an SO/SOBlock/Estimation/PopulationEstimates element
*/
typedef struct so_PopulationEstimates so_PopulationEstimates;

/** \memberof so_PopulationEstimates
 * Create a new empty so_PopulationEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PopulationEstimates_copy, so_PopulationEstimates_free
 */
so_PopulationEstimates *so_PopulationEstimates_new();
/** \memberof so_PopulationEstimates
 * Create a copy of a so_PopulationEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PopulationEstimates_new
 */
so_PopulationEstimates *so_PopulationEstimates_copy(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Free all memory associated with a so_PopulationEstimates structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_PopulationEstimates_new
 */
void so_PopulationEstimates_free(so_PopulationEstimates *self);
void so_PopulationEstimates_ref(so_PopulationEstimates *self);
void so_PopulationEstimates_unref(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Get the MLE element
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the structure representing the MLE element
 * \sa so_PopulationEstimates_set_MLE
 */
so_Table *so_PopulationEstimates_get_MLE(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Get the Bayesian element
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the structure representing the Bayesian element
 * \sa so_PopulationEstimates_set_Bayesian
 */
so_Bayesian *so_PopulationEstimates_get_Bayesian(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Get the OtherMethod element
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the structure representing the OtherMethod element
 * \sa so_PopulationEstimates_set_OtherMethod
 */
so_OtherMethod *so_PopulationEstimates_get_OtherMethod(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Set the MLE element
 * \param self - pointer to a so_PopulationEstimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_PopulationEstimates_get_MLE
 */
void so_PopulationEstimates_set_MLE(so_PopulationEstimates *self, so_Table *value);
/** \memberof so_PopulationEstimates
 * Set the Bayesian element
 * \param self - pointer to a so_PopulationEstimates
 * \param value - A pointer to a \a so_Bayesian to set.
 * \sa so_PopulationEstimates_get_Bayesian
 */
void so_PopulationEstimates_set_Bayesian(so_PopulationEstimates *self, so_Bayesian *value);
/** \memberof so_PopulationEstimates
 * Set the OtherMethod element
 * \param self - pointer to a so_PopulationEstimates
 * \param value - A pointer to a \a so_OtherMethod to set.
 * \sa so_PopulationEstimates_get_OtherMethod
 */
void so_PopulationEstimates_set_OtherMethod(so_PopulationEstimates *self, so_OtherMethod *value);
/** \memberof so_PopulationEstimates
 * Create a new MLE element and insert it into the so_PopulationEstimates
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_PopulationEstimates_create_MLE(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Create a new Bayesian element and insert it into the so_PopulationEstimates
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Bayesian *so_PopulationEstimates_create_Bayesian(so_PopulationEstimates *self);
/** \memberof so_PopulationEstimates
 * Create a new OtherMethod element and insert it into the so_PopulationEstimates
 * \param self - pointer to a so_PopulationEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_OtherMethod *so_PopulationEstimates_create_OtherMethod(so_PopulationEstimates *self);

#endif
