/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_TARGETTOOLMESSAGES_H
#define _SO_TARGETTOOLMESSAGES_H

#include <so/ExternalFile.h>

/** \struct so_TargetToolMessages
	 \brief A structure representing an SO/SOBlock/Estimation/TargetToolMessages element
*/
typedef struct so_TargetToolMessages so_TargetToolMessages;

/** \memberof so_TargetToolMessages
 * Create a new empty so_TargetToolMessages structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_TargetToolMessages_copy, so_TargetToolMessages_free
 */
so_TargetToolMessages *so_TargetToolMessages_new();
/** \memberof so_TargetToolMessages
 * Create a copy of a so_TargetToolMessages structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_TargetToolMessages_new
 */
so_TargetToolMessages *so_TargetToolMessages_copy(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Free all memory associated with a so_TargetToolMessages structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_TargetToolMessages_new
 */
void so_TargetToolMessages_free(so_TargetToolMessages *self);
void so_TargetToolMessages_ref(so_TargetToolMessages *self);
void so_TargetToolMessages_unref(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the Termination element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the Termination string
 * \sa so_TargetToolMessages_set_Termination
 */
char *so_TargetToolMessages_get_Termination(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the Warnings element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the Warnings string
 * \sa so_TargetToolMessages_set_Warnings
 */
char *so_TargetToolMessages_get_Warnings(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the Errors element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the Errors string
 * \sa so_TargetToolMessages_set_Errors
 */
char *so_TargetToolMessages_get_Errors(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the ElapsedTime element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the value of ElapsedTime or NULL if no value is present.
 * \sa so_TargetToolMessages_set_ElapsedTime
 */
double *so_TargetToolMessages_get_ElapsedTime(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the OutputFilePath element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the structure representing the OutputFilePath element
 * \sa so_TargetToolMessages_set_OutputFilePath
 */
so_ExternalFile *so_TargetToolMessages_get_OutputFilePath(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the ChainsNumber element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the value of ChainsNumber or NULL if no value is present.
 * \sa so_TargetToolMessages_set_ChainsNumber
 */
double *so_TargetToolMessages_get_ChainsNumber(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Get the IterationNumber element
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the value of IterationNumber or NULL if no value is present.
 * \sa so_TargetToolMessages_set_IterationNumber
 */
double *so_TargetToolMessages_get_IterationNumber(so_TargetToolMessages *self);
/** \memberof so_TargetToolMessages
 * Set the Termination element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to a \a string to set.
 * \return 0 for success
 * \sa so_TargetToolMessages_get_Termination
 */
int so_TargetToolMessages_set_Termination(so_TargetToolMessages *self, char *value);
/** \memberof so_TargetToolMessages
 * Set the Warnings element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to a \a string to set.
 * \return 0 for success
 * \sa so_TargetToolMessages_get_Warnings
 */
int so_TargetToolMessages_set_Warnings(so_TargetToolMessages *self, char *value);
/** \memberof so_TargetToolMessages
 * Set the Errors element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to a \a string to set.
 * \return 0 for success
 * \sa so_TargetToolMessages_get_Errors
 */
int so_TargetToolMessages_set_Errors(so_TargetToolMessages *self, char *value);
/** \memberof so_TargetToolMessages
 * Set the ElapsedTime element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TargetToolMessages_get_ElapsedTime
 */
void so_TargetToolMessages_set_ElapsedTime(so_TargetToolMessages *self, double *value);
/** \memberof so_TargetToolMessages
 * Set the OutputFilePath element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to a \a so_ExternalFile to set.
 * \sa so_TargetToolMessages_get_OutputFilePath
 */
void so_TargetToolMessages_set_OutputFilePath(so_TargetToolMessages *self, so_ExternalFile *value);
/** \memberof so_TargetToolMessages
 * Set the ChainsNumber element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TargetToolMessages_get_ChainsNumber
 */
void so_TargetToolMessages_set_ChainsNumber(so_TargetToolMessages *self, double *value);
/** \memberof so_TargetToolMessages
 * Set the IterationNumber element
 * \param self - pointer to a so_TargetToolMessages
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TargetToolMessages_get_IterationNumber
 */
void so_TargetToolMessages_set_IterationNumber(so_TargetToolMessages *self, double *value);
/** \memberof so_TargetToolMessages
 * Create a new OutputFilePath element and insert it into the so_TargetToolMessages
 * \param self - pointer to a so_TargetToolMessages
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_ExternalFile *so_TargetToolMessages_create_OutputFilePath(so_TargetToolMessages *self);

#endif
