% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastep.R
\name{output}
\alias{output}
\title{Outputs an observation from a datastep}
\usage{
output()
}
\value{
Observation is marked with a output flag.  No return value.
}
\description{
The \code{output} function will output an observation
from a datastep.  The function takes no parameters.  To use 
the function, simply call it on the rows you want to output.  Typically
it is called within a conditional.  The output function is interesting
in that you can output multiple rows for the same input observation.
}
\examples{
#' # Example 1: Output all cars that are 4 cylinder 
df <- datastep(mtcars, 
               keep = c("mpg", "cyl", "disp"), {
                 
  if (cyl == 4)
    output()
                 
})

df
#     mpg cyl  disp
# 1  22.8   4 108.0
# 2  24.4   4 146.7
# 3  22.8   4 140.8
# 4  32.4   4  78.7
# 5  30.4   4  75.7
# 6  33.9   4  71.1
# 7  21.5   4 120.1
# 8  27.3   4  79.0
# 9  26.0   4 120.3
# 10 30.4   4  95.1
# 11 21.4   4 121.0

# Example 2: Output two rows for each 6 cylinder car

# Prepare sample data
dat <- data.frame(name = rownames(mtcars), mtcars, stringsAsFactors = FALSE)

# Perform datastep
df <- datastep(dat, 
               keep = c("name", "mpg", "cyl", "disp", "seq"), {
                 
  if (cyl == 6) {
    seq <- 1
    output()
    seq <- 2
    output()
  }
                 
})

df
#              name  mpg cyl  disp seq
# 1       Mazda RX4 21.0   6 160.0   1
# 2       Mazda RX4 21.0   6 160.0   2
# 3   Mazda RX4 Wag 21.0   6 160.0   1
# 4   Mazda RX4 Wag 21.0   6 160.0   2
# 5  Hornet 4 Drive 21.4   6 258.0   1
# 6  Hornet 4 Drive 21.4   6 258.0   2
# 7         Valiant 18.1   6 225.0   1
# 8         Valiant 18.1   6 225.0   2
# 9        Merc 280 19.2   6 167.6   1
# 10       Merc 280 19.2   6 167.6   2
# 11      Merc 280C 17.8   6 167.6   1
# 12      Merc 280C 17.8   6 167.6   2
# 13   Ferrari Dino 19.7   6 145.0   1
# 14   Ferrari Dino 19.7   6 145.0   2

# Example 3: Create data frame using output() functions
df <- datastep(data.frame(), {

  # Row 1
  COL1 <- 1
  COL2 <- "One"
  output()
  
  # Row 2
  COL1 <- 2
  COL2 <- "Two"
  output()

})

df
#   COL1 COL2
# 1    1  One
# 2    2  Two
}
\seealso{
Other datastep: 
\code{\link{[.dsarray}()},
\code{\link{datastep}()},
\code{\link{delete}()},
\code{\link{dsarray}()},
\code{\link{dsattr}()},
\code{\link{length.dsarray}()}
}
\concept{datastep}
