% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_replace}
\alias{lib_replace}
\title{Replace Data in a Data Library}
\usage{
lib_replace(x, ..., name = NULL)
}
\arguments{
\item{x}{The library to replace data in.}

\item{...}{The data frame(s) to replace.  If you wish to replace more than
one data set, separate with commas.}

\item{name}{The reference name to use for the data.  By default,
the name will be the variable name.  To assign a name different
from the variable name, assign a quoted name to this parameter.  If more
than one data set is being replaced, assign a vector of quoted names.}
}
\description{
The \code{\link{lib_replace}} function replaces a data frame
in an existing data library.  The function will replace the data
in the library list, the data in the workspace (if loaded), 
and immediately write the new data to the library
directory location.  The data will be written in the file format
associated with the library engine.
}
\examples{
#' # Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add data to the library
lib_add(dat, mtcars)
# library 'dat': 3 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size        LastModified
# 1  mtcars       rds   32   11 7.5 Kb 2020-11-05 19:32:00

# Replace data with a subset
lib_replace(dat, mtcars[1:10, 1:5], name = "mtcars")
# library 'dat': 3 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size        LastModified
# 1  mtcars       rds   10    5 7.5 Kb 2020-11-05 19:33:00

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
