% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other-code-translations.R
\name{get_language_from_code}
\alias{get_language_from_code}
\title{Conversion from language code to language name}
\usage{
get_language_from_code(x)
}
\arguments{
\item{x}{A language code (defined in the Marc standards) or a vector
of language codes}
}
\value{
Returns the language name. NA if cannot be matched
        to language in standard.
}
\description{
Takes a language code (defined in the Marc standards)
and returns the language name.
}
\examples{

get_language_from_code("yor")
# Yoruba

# tolerant of case and leading/trailing whitespace
get_language_from_code(c("yor", " SPA ", "not-a-language", "nah", NA))
# c("Yoruba", "Spanish", NA, "Nahuatl", NA)

}
