% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{check_isbn_13_check_digit}
\alias{check_isbn_13_check_digit}
\title{Check the check digit of an ISBN 13}
\usage{
check_isbn_13_check_digit(x, allow.hyphens = TRUE, errors.as.false = TRUE)
}
\arguments{
\item{x}{A string of 13 digits}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed
(default is \code{TRUE})}

\item{errors.as.false}{return false if error instead of throwing error
(default is \code{TRUE})}
}
\value{
Returns TRUE if check passes, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISBN 13 and verifies that check digit
checks out
}
\examples{

check_isbn_13_check_digit("9780306406157")          # TRUE
check_isbn_13_check_digit("978-0-306-40615-7")      # TRUE

# vectorized
check_isbn_13_check_digit(c("978-0-306-40615-7", "9783161484103"))  # TRUE FALSE

}
