% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentenceSimil.R
\name{sentenceSimil}
\alias{sentenceSimil}
\title{Compute distance between sentences}
\usage{
sentenceSimil(sentenceId, token, docId = NULL, sentencesAsDocs = FALSE)
}
\arguments{
\item{sentenceId}{A character vector of sentence IDs corresponding to the \code{docId} and \code{token} arguemants.}

\item{token}{A character vector of tokens corresponding to the \code{docId} and \code{sentenceId} arguemants.}

\item{docId}{A character vector of document IDs corresponding to the \code{sentenceId} and \code{token} arguemants.  Can be \code{NULL} if \code{sentencesAsDocs} is \code{TRUE}.}

\item{sentencesAsDocs}{\code{TRUE} or \code{FALSE}, indicating whether or not to treat sentences as documents when calculating tfidf scores. If \code{TRUE}, inverse document frequency will be calculated as inverse sentence frequency (useful for single document extractive summarization)}
}
\value{
A 3 column dataframe of pairwise distances between sentences. Columns: \code{sent1} (sentence id), \code{sent2} (sentence id), & \code{dist} (distance between \code{sent1} and \code{sent2}).
}
\description{
Compute distance between sentences using modified idf cosine distance from "LexRank: Graph-based Lexical Centrality as Salience in Text Summarization".  Output can be used as input to \code{\link{lexRankFromSimil}}.
}
\examples{
sentenceSimil(docId=c("d1","d1","d2","d2"),
              sentenceId=c("d1_1","d1_1","d2_1","d2_1"),
              token=c("i", "ran", "jane", "ran"))
}
\references{
\url{http://www.cs.cmu.edu/afs/cs/project/jair/pub/volume22/erkan04a-html/erkan04a.html}
}

