% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lets_subsetPAM.R
\name{lets.subsetPAM}
\alias{lets.subsetPAM}
\title{Subset a PresenceAbsence object based on species names}
\usage{
lets.subsetPAM(x, names, remove.cells = TRUE)
}
\arguments{
\item{x}{A \code{\link{PresenceAbsence}} object.}

\item{names}{Character vector with species names to subset the \code{PresenceAbsence} object.}

\item{remove.cells}{Logical, if \code{TRUE} the final matrix will not contain cells in the
grid with a value of zero (i.e. sites with no species present).}
}
\value{
The result is an object of class PresenceAbsence subseted.
}
\description{
Subset a PresenceAbsence object based on species character vector
provided by the user.
}
\examples{
\dontrun{
data(PAM)
# PAM before subset
plot(PAM, xlab = "Longitude", ylab = "Latitude",
     main = "Phyllomedusa species richness")

# Subset PAM to the first 20 species
PAMsub <- lets.subsetPAM(PAM, PAM[[3]][1:20])
plot(PAMsub, xlab = "Longitude", ylab = "Latitude",
     main = "Phyllomedusa species richness")
}
}
\author{
Bruno Vilela
}
\seealso{
\code{\link{plot.PresenceAbsence}}

\code{\link{lets.presab.birds}}
}

