\name{regPlot}
\alias{regPlot}

\title{regPlot Analysis}

\description{
Following a call to the \code{lessR} function \code{\link{Regression}}, in which the returned values of the function are saved into an object, allows the default plots generated by \code{\link{Regression}} to be accessed one at a time. The specific motivation for this function is to allow custom placement of the graphs from the regression analysis from within \code{knitr}. Usually the \code{graphics=FALSE} parameter is set on the call to \code{\link{Regression}} within \code{knitr} to suppress the normal graphic output that leads to the generation of the graphs at the beginning of the \code{knitr} output.
}

\usage{
regPlot(out, type, digits.d=NULL, pred.intervals=TRUE,
         res.sort=c("cooks","rstudent","dffits","off"),
         res.rows=NULL, cooks.cut=1, scatter.coef=NULL, 
         pdf=FALSE, width=5, height=5, manage.gr=FALSE, \ldots)
}


\arguments{
  \item{out}{The object returned by the \code{lessR} function  \code{\link{Regression}}.}
  \item{type}{Type of plot: 1 plots the scatter plot for a single predictor
        variable, or the scatter plot matrix for multiple predictors. If a single
        scatter plot, then the confidence and prediction intervals are included. 2
        plots the density and histogram of residuals and 3 plots a scatter plot of
        the residuals with the fitted values.}
  \item{digits.d}{For the Basic Analysis, the number of decimal digits,
        set by default to at least 3 or the largest number of digits in the values 
        of the response variable plus 1.}
  \item{pred.intervals}{If set to \code{FALSE}, the scatter plot for a single predictor
        with the response does not contain prediction and confidence intervals.}
  \item{res.sort}{Default is \code{"cooks"}, for specifying Cook's distance as the sort
       criterion for the display of the rows of data and associated residuals. Other values 
       are \code{"rstudent"} for externally Studentized residuals, \code{"dffits"} for dffits
       and \code{"off"} to not sort the rows of data.}
  \item{res.rows}{Default is 20, which lists the first 20 rows of data sorted by the
       specified sort criterion.  To disable residuals, specify a value of 0.  To see 
       the output for all observations, specify a value of \code{"all"}.}
  \item{cooks.cut}{Cutoff value of Cook's Distance at which observations with a larger value 
       are flagged in red and labeled in the resulting scatterplot of Residuals and Fitted 
       Values.  Default value is 1.0.}
  \item{scatter.coef}{Display the correlation coefficients in the upper triangle of the
        scatterplot matrix.}
  \item{pdf}{If \code{TRUE}, then graphics are written to pdf files.}
  \item{width}{Width of the pdf file in inches.}
  \item{height}{Height of the pdf file in inches.}
  \item{manage.gr}{Usually leave \code{FALSE}. Refers to graphic management of the \code{lessR} system.}
  \item{\dots}{Other parameter values for R function \code{\link{lm}} which provides the core computations.} 
}


\details{
OVERVIEW\cr
The ability to separate plots is particularly useful with \code{knitr} to break up the output to intersperse comments between the plots. For Plot 1, for single predictor a scatter plot with the regression line and confidence and prediction intervals is produced.  Otherwise a scatter plot matrix of all the variables in the models is obtained.

To help assess the validity of the model, Plot 2 is of the distribution of the residuals, histogram and density plots, both general and normal. Plot 3 plots the residuals against the fitted value and also identifies the points with the largest values of Cook's distance.
}

\references{
Gerbing, D. W. (2014). R Data Analysis without Programming, Chapters 9 and 10, NY: Routledge.
}

\author{David W. Gerbing (Portland State University; \email{gerbing@pdx.edu})}

\seealso{
\code{\link{lm}}, \code{\link{Regression}}
}

\examples{
# read internal data set
d <- rd("Reading", in.lessR=TRUE, quiet=TRUE)
# do regression analysis, save result into out
reg.out <- reg(Reading ~ Verbal)
# The full output already contains these plots, obtained by
# entering the name of the saved object
reg.out
# Particularly for knitr it is useful to obtain the plots
#   separately from the full output
# Get the scatter plot of the data with the regression line
#   and prediction and confidence intervals 
regPlot(reg.out, 1)

# Can use with multiple regression for the scatter plot matrix
r <- reg(Reading ~ Verbal + Absent + Income)
regPlot(r, 1, scatter.coef=TRUE)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ regPlot }




