% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brackets.R
\name{brackets_horisontal}
\alias{brackets_horisontal}
\alias{brackets_horizontal}
\alias{brackets_vertical}
\title{Axis brackets instead of axis ticks and lines}
\usage{
brackets_horisontal(direction = c("up", "down"), length = unit(0.05,
  "native"), tick.length = waiver())

brackets_horizontal(direction = c("up", "down"), length = unit(0.05,
  "native"), tick.length = waiver())

brackets_vertical(direction = c("left", "right"), length = unit(0.05,
  "native"), tick.length = waiver())
}
\arguments{
\item{direction}{Which way should the opening side of the brackets point?
up, down, left, or right?}

\item{length}{Length of the unit, parallel with axis line.}

\item{tick.length}{Height (width) of x-axis (y-axis) bracket.
If \code{waiver()} (default), use \code{axis.ticks.length} from \code{\link{theme}}.}
}
\description{
To be used with \code{\link{coord_flex_cart}},
\code{\link{coord_capped_cart}}, etc. for displaying brackets instead
of the axis ticks and lines.
}
\details{
The looks of the brackets are taken from \code{theme(axis.ticks)}, or
\code{theme(axis.ticks.x)} and \code{theme(axis.ticks.y)}, respectively.

It does not re-calculate tick marks, but lets \code{scale_x_*} and \code{scale_y_*}
calculate and draw ticks and labels, and then modifies the ticks with brackets.
}
\examples{
library(ggplot2)
p <- ggplot(mpg, aes(as.factor(cyl), hwy, colour=class)) +
  geom_point(position=position_jitter(width=0.3)) +
  theme_bw() +
  theme(panel.border = element_blank(), axis.line = element_line())
p

p <- p + coord_flex_cart(bottom=brackets_horisontal(length=unit(0.08, 'npc')))
p
# However getting the correct width is a matter of tweaking either length or
# position_jitter...

# A further adjustment,
p + theme(panel.grid.major.x = element_blank())
}

