% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lathyrus}
\alias{lathyrus}
\title{Demographic Dataset of \emph{Lathyrus vernus} Population}
\format{
A data frame with 1119 individuals and 34 variables. Each row
corresponds to a unique individual, and each variable from \code{Volume88}
on refers to the state of the individual in a given year.

\describe{
  \item{SUBPLOT}{A variable refering to patch within the population.}
  \item{GENET}{A numeric variable giving a unique number to each 
  individual.}
  \item{Volume88}{Aboveground volume in cubic mm in 1988.}
  \item{lnVol88}{Natural logarithm of \code{Volume88}.}
  \item{FCODE88}{Equals 1 if flowering and 0 if not flowering in 1988.}
  \item{Flow88}{Number of flowers in 1988.}
  \item{Intactseed88}{Number of intact mature seeds produced in 1988.
  Not always an integer, as in some cases seed number was estimated via 
  linear modeling.}
  \item{Dead1988}{Marked as 1 if known to be dead in 1988.}
  \item{Dormant1988}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1988.}
  \item{Missing1988}{Marked as 1 if not found in 1988.}
  \item{Seedling1988}{Marked as 1, 2, or 3 if observed as a seedling in year
  \emph{t}. Numbers refer to certainty of assignment: 1 = certain that plant
  is a seedling in 1988, 2 = likely that plant is a seedling in 1988,
  3 = probable that plant is a seedling in 1988.}
  \item{Volume89}{Aboveground volume in cubic mm in 1989.}
  \item{lnVol89}{Natural logarithm of \code{Volume89}.}
  \item{FCODE89}{Equals 1 if flowering and 0 if not flowering in 1989.}
  \item{Flow89}{Number of flowers in 1989.}
  \item{Intactseed89}{NZumber of intact mature seeds produced in 1989.
  Not always an integer, as in some cases seed number was estimated via
  linear modeling.}
  \item{Dead1989}{Marked as 1 if known to be dead in 1989.}
  \item{Dormant1989}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1989.}
  \item{Missing1989}{Marked as 1 if not found in 1989.}
  \item{Seedling1989}{Marked as 1, 2, or 3 if observed as a seedling in
  year \emph{t}. Numbers refer to certainty of assignment: 1 = certain 
  that plant is a seedling in 1989, 2 = likely that plant is a seedling 
  in 1989, 3 = probable that plant is a seedling in 1989.}
  \item{Volume90}{Aboveground volume in mm<sup>3</sup> in 1990.}
  \item{lnVol90}{Natural logarithm of \code{Volume90}.}
  \item{FCODE90}{Equals 1 if flowering and 0 if not flowering in 1990.}
  \item{Flow90}{Number of flowers in 1990.}
  \item{Intactseed90}{NZumber of intact mature seeds produced in 1990.
  Not always an integer, as in some cases seed number was estimated via 
  linear modeling.}
  \item{Dead1990}{Marked as 1 if known to be dead in 1990.}
  \item{Dormant1990}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1990.}
  \item{Missing1990}{Marked as 1 if not found in 1990.}
  \item{Seedling1990}{Marked as 1, 2, or 3 if observed as a seedling in
  year \emph{t}. Numbers refer to certainty of assignment: 1 = certain 
  that plant is a seedling in 1990, 2 = likely that plant is a seedling
  in 1990, 3 = probable that plant is a seedling in 1990.}
  \item{Volume91}{Aboveground volume in mm<sup>3</sup> in 1991.}
  \item{lnVol91}{Natural logarithm of \code{Volume91}.}
  \item{FCODE91}{Equals 1 if flowering and 0 if not flowering in 1991.}
  \item{Flow91}{Number of flowers in 1991.}
  \item{Intactseed91}{NZumber of intact mature seeds produced in 1991.
  Not always an integer, as in some cases seed number was estimated via
  linear modeling.}
  \item{Dead1991}{Marked as 1 if known to be dead in 1991.}
  \item{Dormant1991}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1991.}
  \item{Missing1991}{Marked as 1 if not found in 1991.}
  \item{Seedling1991}{Marked as 1, 2, or 3 if observed as a seedling 
  in year \emph{t}. Numbers refer to certainty of assignment: 
  1 = certain that plant is a seedling in 1991, 2 = likely that plant 
  is a seedling in 1991, 3 = probable that plant is a seedling in 
  1991.}
}
}
\source{
Ehrlen, J. 2000. The dynamics of plant populations: does the 
history of individuals matter? \emph{Ecology} 81(6):1675-1684.
}
\usage{
data(lathyrus)
}
\description{
A dataset containing the states and fates of \emph{Lathyrus vernus} (spring
vetch), family Fabaceae, from a population in Sweden monitored annually
from 1988 to 1991 in six study plots.
}
\examples{
# Lathyrus example using blocksize - when repeated patterns exist in variable
# order
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

lambda3(ehrlen3mean)

# Lathyrus example without blocksize - when no repeated patterns exist in
# variable order and all variables names are specified
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET",
  juvcol = c("Seedling1988", "Seedling1989", "Seedling1990", "Seedling1991"),
  sizeacol = c("Volume88", "Volume89", "Volume90", "Volume91"),
  repstracol = c("FCODE88", "FCODE89", "FCODE90", "FCODE91"),
  fecacol = c("Intactseed88", "Intactseed89", "Intactseed90", "Intactseed91"),
  deadacol = c("Dead1988", "Dead1989", "Dead1990", "Dead1991"),
  nonobsacol = c("Dormant1988", "Dormant1989", "Dormant1990", "Dormant1991"),
  censorcol = c("Missing1988", "Missing1989", "Missing1990", "Missing1991"), 
  stageassign = lathframe, stagesize = "sizea",
  censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

lambda3(ehrlen3mean)
}
\keyword{datasets}
