% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_learner.R
\name{cv.learner}
\alias{cv.learner}
\title{Cross-validation for LEARNER}
\usage{
cv.learner(
  Y_source,
  Y_target,
  r,
  lambda_1_all,
  lambda_2_all,
  step_size,
  n_folds = 4,
  n_cores = 1,
  control = list()
)
}
\arguments{
\item{Y_source}{matrix containing the source population data, as in \code{\link{learner}}}

\item{Y_target}{matrix containing the target population data, as in \code{\link{learner}}}

\item{r}{(optional) integer specifying the rank of the knowledge graphs, as in \code{\link{learner}}}

\item{lambda_1_all}{vector of numerics specifying the candidate values of \eqn{\lambda_1} (see Details)}

\item{lambda_2_all}{vector of numerics specifying the candidate values of \eqn{\lambda_2} (see Details)}

\item{step_size}{numeric scalar specifying the step size for the Newton steps in the numerical optimization algorithm, as in \code{\link{learner}}}

\item{n_folds}{an integer specify the number of cross-validation folds. The default is \code{4}.}

\item{n_cores}{an integer specifying the number of CPU cores in parallelization. Parallelization is performed across the different candidate \eqn{(\lambda_1, \lambda_2)} pairs. The default is \code{1}, i.e., no parallelization.}

\item{control}{a list of parameters for controlling the stopping criteria for the numerical optimization algorithm, as in \code{\link{learner}}.}
}
\value{
A list with the following elements:
\item{lambda_1_min}{value of \eqn{\lambda_1} with the smallest MSE}
\item{lambda_2_min}{value of \eqn{\lambda_2} with the smallest MSE}
\item{mse_all}{matrix containing MSE value for each \eqn{(\lambda_1, \lambda_2)} pair. The rows correspond to the \eqn{\lambda_1} values, and the columns correspond to the \eqn{\lambda_2} values.}
\item{r}{rank value used.}
}
\description{
This function performs k-fold cross-validation to select the nuisance parameters \eqn{(\lambda_1, \lambda_2)} for \code{\link{learner}}.
}
\details{
Given sets of candidate values of \eqn{\lambda_1} and \eqn{\lambda_2}, this function performs k-fold cross-validation to select the pair \eqn{(\lambda_1, \lambda_2)} with the smallest held out error. This function randomly partitions the entries of \code{Y_target} into \eqn{k} (approximately) equally sized subsamples. The training data sets are obtained by removing one of the \eqn{k} subsamples and the corresponding test data sets are based on the held out subsamples. The \code{\link{learner}} function is applied to each training data set. The held out error is computed by the mean squared error comparing the entries in the test data sets with those imputed from the LEARNER estimates. See McGrath et al. (2024) for further details.
}
\examples{
res <- cv.learner(Y_source = dat_highsim$Y_source,
                  Y_target = dat_highsim$Y_target,
                  lambda_1_all = c(1, 10, 100),
                  lambda_2_all = c(1, 10, 100),
                  step_size = 0.003)


}
\references{
McGrath, S., Zhu, C,. Guo, M. and Duan, R. (2024). \emph{LEARNER: A transfer learning method for low-rank matrix estimation}. arXiv preprint	arXiv:2412.20605.
}
