% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyprint.R
\name{easyprintOptions}
\alias{easyprintOptions}
\title{easyprintOptions}
\usage{
easyprintOptions(
  title = "Print map",
  position = "topleft",
  sizeModes = list("A4Portrait", "A4Landscape", "Current"),
  defaultSizeTitles = NULL,
  exportOnly = FALSE,
  tileLayer = NULL,
  tileWait = 500,
  filename = "map",
  hidden = FALSE,
  hideControlContainer = TRUE,
  hideClasses = list(),
  customWindowTitle = NULL,
  spinnerBgColor = "#0DC5C1",
  customSpinnerClass = "epLoader"
)
}
\arguments{
\item{title}{Sets the text which appears as the tooltip of the print/export button}

\item{position}{Positions the print button}

\item{sizeModes}{Options available include \code{CurrentSize}, \code{A4Portrait},
\code{A4Landscape} or a custom size object}

\item{defaultSizeTitles}{Button tooltips for the default page sizes}

\item{exportOnly}{If set to \code{TRUE} the map is exported to a .png file}

\item{tileLayer}{A tile layer that you can wait for to draw (helpful when resizing)}

\item{tileWait}{How long to wait for the tiles to draw (helpful when resizing)}

\item{filename}{Name of the file if \code{exportOnly} option is \code{TRUE}}

\item{hidden}{Set to \code{TRUE} if you don't want to display the toolbar.
Instead you can create your own buttons or fire print events programmatically.}

\item{hideControlContainer}{Hides the leaflet controls like the zoom buttons
and the attribution on the print out}

\item{hideClasses}{Hides classes on the print out. Use a list of strings as
follow : list('div1', 'div2')}

\item{customWindowTitle}{A title for the print window which will get
added the printed paper}

\item{spinnerBgColor}{A valid css colour for the spinner background color}

\item{customSpinnerClass}{A class for a custom css spinner to use while
waiting for the print.}
}
\value{
A list of options for the 'easyprint' control
}
\description{
Create a list of further options for the easyprint plugin.
}
\references{
\url{https://github.com/rowanwins/leaflet-easyPrint}
}
\seealso{
Other EasyPrint Functions: 
\code{\link{addEasyprint}()},
\code{\link{easyprintMap}()},
\code{\link{removeEasyprint}()}
}
\concept{EasyPrint Functions}
