% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.plots.R
\name{plot.ldt.estim}
\alias{plot.ldt.estim}
\title{Plot Diagnostics for \code{ldt.estim} Object}
\usage{
\method{plot}{ldt.estim}(
  x,
  equation = 1,
  type = c(1, 2, 3, 4, 5, 6),
  ablineArgs = list(col = "lightblue"),
  textArgs = list(pos = 3, cex = 0.7, col = "red"),
  ...
)
}
\arguments{
\item{x}{An object of type \code{ldt.estim}.}

\item{equation}{A number or a name of endogenous variable specifying an equation in the estimated system.}

\item{type}{One of these numbers: 1, 2, 3, or 5. See \code{which} argument in \link{plot.lm} documentation.}

\item{ablineArgs}{A list of additional arguments to customize the "text" function used for labeling influential observations.}

\item{textArgs}{A list of additional arguments to customize the "abline" function.}

\item{...}{additional arguments to be passed to "plot" (or "qqnorm" function for \code{type=2}, or "barplot" for \code{type=4}).}
}
\value{
This function creates diagnostic plots for regression models.
It also returns a list with \code{x} and \code{y} data used in plot functions.
}
\description{
This function creates diagnostic plots for estimated regression models of \code{ldt.estim} class.
}
\details{
This function is designed to be similar to \link{plot.lm} function.
However, note that an \code{ldt.estim} object might be a system estimation.

Some plots use standardized residuals. Note that they are not calculated in a system estimation context. See \link{residuals.ldt.estim} documentation for a description.
Cook's distance is also calculated equation-wise. Its formula is:
\deqn{
d = \frac{r_i^2}{k*var(r)}\frac{h_{ii}}{(1-h_{ii})^2}
}
where \eqn{r_i} and \eqn{h_{ii}} are residual and leverage in \eqn{i}-th observation, respectively. \eqn{var(r)} is variance of residuals and \eqn{k} is the number of estimated coefficients in the equation.
Note that Cook's distance is not implemented for weighted observations.
}
