% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FindTopicsNumber}
\alias{FindTopicsNumber}
\title{FindTopicsNumber}
\usage{
FindTopicsNumber(dtm, topics = seq(10, 40, by = 10),
  metrics = "Griffiths2004", method = "Gibbs", control = list(),
  mc.cores = 1L, verbose = FALSE)
}
\arguments{
\item{dtm}{An object of class "\link[tm]{DocumentTermMatrix}" with
term-frequency weighting or an object coercible to a
"\link[slam]{simple_triplet_matrix}" with integer entries.}

\item{topics}{Vvector with number of topics to compare different models.}

\item{metrics}{String or vector of possible metrics: "Griffiths2004",
"CaoJuan2009", "Arun2010", "Deveaud2014".}

\item{method}{The method to be used for fitting; see \link[topicmodels]{LDA}.}

\item{control}{A named list of the control parameters for estimation or an
object of class "\linkS4class{LDAcontrol}".}

\item{mc.cores}{Integer; The number of CPU cores to processes models
simultaneously.}

\item{verbose}{If false (default), supress all warnings and additional
information.}
}
\value{
Data-frame with one or more metrics.  numbers of topics and
  corresponding values of metric. Can be directly used by
  \code{\link{FindTopicsNumber_plot}} to draw a plot.
}
\description{
Calculates different metrics to estimate the most preferable number of topics
for LDA model.
}
\examples{
\dontrun{

library(topicmodels)
data("AssociatedPress", package="topicmodels")
dtm <- AssociatedPress[1:10, ]
FindTopicsNumber(dtm, topics = 2:10, metrics = "Arun2010", mc.cores = 1L)
}

}

