% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search_montecarlo.R
\name{search_montecarlo}
\alias{search_montecarlo}
\title{Searches for a subset satisfying the test by randomly selecting
subspaces of decreasing size.}
\usage{
search_montecarlo(sspace, condition, covariates, halting_test, thresh,
  replicates)
}
\arguments{
\item{sspace}{An ordered subject subspace: a list of vectors,
with one vector per group containing the corresponding subject indices.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A vector or columnwise matrix containing
                     covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
                     which is TRUE iff the conditions are matched.}

\item{thresh}{The statistical threshold to pass onto the
                     aforementioned test.}

\item{replicates}{The maximum number of Monte Carlo replications to be
                     performed. This is only used for the "montecarlo"
                     method.}
}
\description{
Searches for a subset satisfying the test by randomly selecting
subspaces of decreasing size.
}

