% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_collect_data.R
\name{aml_collect_data}
\alias{aml_collect_data}
\title{Function to read new data, transform, aggregate and save data for further retraining of regression model
for a single currency pair}
\usage{
aml_collect_data(indicator_dataset, symbol, timeframe, path_data)
}
\arguments{
\item{indicator_dataset}{Dataset containing assets indicator which pattern will be used as predictor}

\item{symbol}{Character symbol of the asset for which to train the model}

\item{timeframe}{Data timeframe e.g. 1 min}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}
}
\value{
Function is writing files into Decision Support System folder, mainly file object with the model
}
\description{
Function is collecting data from the csv files
Data objects are transformed to be suitable for Regression Modelling.
Price change will be in the column 'LABEL', column X1 will keep the time index
Result will be written to a new or aggregated to the existing '.rds' file

Function is also checking that generated dataset is not too big.
Should the dataset is too big (e.g. > 50000 rows), then only latest 40000 rows will be used.
}
\details{
Function is not handling shift of the price and indicator datasets.

This function is relying on the data collection from the dedicated data robot
Other 'aml_*' functions will work based on the data processed by this function
}
\examples{

# write examples for the function
library(dplyr)
library(readr)
library(lubridate)
library(lazytrade)
library(magrittr)

# sample dataset
ind = system.file("extdata", "AI_RSIADXUSDJPY60.csv",
                  package = "lazytrade") \%>\% read_csv(col_names = FALSE)

# convert to POSIX format
ind$X1 <- ymd_hms(ind$X1)

# create temporary path (check output of tempdir() to check the result)
path_data <- normalizePath(tempdir(),winslash = "/")

# data transformation using the custom function for one symbol
aml_collect_data(indicator_dataset = ind,
                 symbol = 'USDJPY',
                 timeframe = 60,
                 path_data = path_data)


}
\author{
(C) 2020 Vladimir Zhbanko
}
