% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyNumbers.R
\name{intervals}
\alias{intervals}
\title{Intervals for lazy numbers}
\usage{
intervals(x)
}
\arguments{
\item{x}{a \code{lazyVector} object or a \code{lazyMatrix} object}
}
\value{
A named list (\code{"inf"} and \code{"sup"}) containing: two numeric 
  vectors if \code{x} is a lazy vector, two numeric matrices if \code{x} is 
  a lazy matrix.
}
\description{
For each lazy number in a \code{lazyVector} object or a 
  \code{lazyMatrix} object, this function computes an interval containing 
  this lazy number.
}
\examples{
library(lazyNumbers)
x <- lazynb(22) / lazynb(7)
itrv <- intervals(x)
print(itrv, digits = 17L)
x_dbl <- as.double(x)
itrv$inf <= x_dbl & x_dbl <= itrv$sup
}
