% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement.error.R
\name{twostage}
\alias{twostage}
\title{Two-stage estimator (non-linear SEM)}
\usage{
twostage(model1, model2, data = parent.frame(), predictfun = function(mu,
  var, data, ...) cbind(u1 = mu[, 1], u2 = mu[, 1]^2 + var[1]), id1, id2,
  all = FALSE, ...)
}
\arguments{
\item{model1}{Stage 1 measurement model}

\item{model2}{Stage 2 SEM}

\item{data}{data.frame}

\item{predictfun}{Prediction of latent variable}

\item{id1}{Optional id-variable (stage 1 model)}

\item{id2}{Optional id-variable (stage 2 model)}

\item{all}{If TRUE return additional output (naive estimates)}

\item{...}{Additional arguments to lower level functions}
}
\description{
Two-stage estimator for non-linear structural equation models
}
\examples{
m <- lvm(c(x1,x2,x3)~f1,f1~z,
         c(y1,y2,y3)~f2,f2~f1+z)
latent(m) <- ~f1+f2
d <- simulate(m,100,p=c("f2,f2"=2,"f1,f1"=0.5),seed=1)

## Full MLE
ee <- estimate(m,d)

## Manual two-stage
\dontrun{
m1 <- lvm(c(x1,x2,x3)~f1,f1~z); latent(m1) <- ~f1
e1 <- estimate(m1,d)
pp1 <- predict(e1,f1~x1+x2+x3)

d$u1 <- pp1[,]
d$u2 <- pp1[,]^2+attr(pp1,"cond.var")
m2 <- lvm(c(y1,y2,y3)~eta,c(y1,eta)~u1+u2+z); latent(m2) <- ~eta
e2 <- estimate(m2,d)
}

## Two-stage
m1 <- lvm(c(x1,x2,x3)~f1,f1~z); latent(m1) <- ~f1
m2 <- lvm(c(y1,y2,y3)~eta,c(y1,eta)~u1+u2+z); latent(m2) <- ~eta
pred <- function(mu,var,data,...)
    cbind("u1"=mu[,1],"u2"=mu[,1]^2+var[1])
(mm <- twostage(m1,m2,data=d,predictfun=pred))

if (interactive()) {
    pf <- function(p) p["eta"]+p["eta~u1"]*u + p["eta~u2"]*u^2
    plot(mm,f=pf,data=data.frame(u=seq(-2,2,length.out=100)),lwd=2)
}
}

