% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lava.tobit-package.R
\docType{package}
\name{lava.tobit}
\alias{lava.tobit}
\alias{lava.tobit-package}
\alias{lava.tobit-package}
\title{Estimation and simulation of probit and tobit latent variable models
 
Framwork for estimating parameters and simulate data from Latent Variable
Models with binary and censored observations. Plugin for the \code{lava}
package}
\description{
\tabular{ll}{ Package: \tab lava.tobit \cr Type: \tab Package \cr Version:
\tab 0.4-5 \cr Date: \tab 2012-03-15 \cr License: \tab GPL-3 \cr LazyLoad:
\tab yes \cr }
}
\examples{

library(lava.tobit)
m <- lvm(list(c(y,z) ~ x, y~z))
## Simulate 200 observation from path analysis model
## with all slopes and residual variances set to 1 and intercepts 0:
d <- sim(m,200,seed=1)
## Dichotomize y and introduce censoring on z
d <- transform(d, y=as.factor(y>0), z=Surv(z,z<2))
\donttest{
e <- estimate(m,d,control=list(trace=1),estimator="gaussian")
effects(e,y~x)
}

}
\author{
Klaus K. Holst Maintainer: <kkho@biostat.ku.dk>
}
\keyword{package}
