% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalNparReg.R
\name{crossvalNparReg}
\alias{crossvalNparReg}
\title{Crossvalidation for non-parametric regression.}
\usage{
crossvalNparReg(formLatticeOutput, Z, PointPattern, M = 0.5, max_steps = 200)
}
\arguments{
\item{formLatticeOutput}{An object from formLattice or editLattice.}

\item{Z}{Vector of response values to be smoothed.}

\item{PointPattern}{A 2-column matrix or data frame of locations.}

\item{M}{Maximum probability that the random walk moves.}

\item{max_steps}{Maximum number of steps attempted.}
}
\value{
A list consisting of 
\itemize{
  \item SumSq Vector of crossvalidated sums of squares
  \item Number of steps that minimizes the crossvalidated SS.
  }
}
\description{
Performs least-squares crossvalidation for the 
lattice-based non-parametric regression estimator.
}
\details{
For a given k, deleted residuals are computed for each of the observations.
The crossvalidation is based on minimization of the squares of the
deleted residuals.
}
\examples{
data(nparExample)
attach(nparExample)
plot.new()
#  Simulate a response variable
index1 <- (grid2[,2]<0.8)|(grid2[,1]>0.6)
Z <- rep(NA,length(grid2[,1]))
n1 <- sum(index1)
n2 <- sum(!index1)
Z[index1] <- 3*grid2[index1,1] + 4 + rnorm(n1,0,sd=0.4)
Z[!index1] <- -2*grid2[!index1,1] + 4 + rnorm(n2,0,sd=0.4)
#
plot(polygon2,type="n")
polygon(polygon2)
points(grid2,pch=19,cex=0.5,xlim=c(-0.1,1))
text(grid2,labels=round(Z,1),pos=4,cex=0.5)
#
nodeFillingOutput <- nodeFilling(poly=polygon2, node_spacing=0.025)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
hold <- crossvalNparReg(formLatticeOutput,Z,
                       PointPattern=grid2,M=0.5,max_steps = 40)
NparRegOut <- createNparReg(formLatticeOutput,Z,PointPattern=grid2,k=hold$k)
plot(NparRegOut)
}
\references{
Ronald P. Barry, Julie McIntyre. Estimating animal 
densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative to 
the kernel density estimator. Ecological Modelling 
222 (2011) 1666-1672.

Julie McIntyre, Ronald P. Barry (2018)  A Lattice-Based 
Smoother for Regions with Irregular Boundaries and Holes.  
Journal of Computational and Graphical Statistics.  In Press.
}
\author{
Ronald P. Barry
}
