% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalDensity.R
\name{crossvalDensity}
\alias{crossvalDensity}
\title{UBC crossvalidation for the lattice-based density estimator.}
\usage{
crossvalDensity(
  formLatticeOutput,
  PointPattern,
  M = 0.5,
  max_steps = 200,
  sparse = TRUE
)
}
\arguments{
\item{formLatticeOutput}{An object from formLattice or editLattice.}

\item{PointPattern}{A matrix or data frame of locations.}

\item{M}{The maximum probability that the random walk will move.}

\item{max_steps}{The maximum number of steps attempted.}

\item{sparse}{Whether spare matrix computations used.}
}
\value{
\itemize{
  \item ucv The value of the goodness-of-fit statistic.
  \item k The number of steps.
}
}
\description{
A function to perform crossvalidation to determine the smoothing
parameter for the lattice-based density estimator.  It minimizes the
UCV criterion.
}
\details{
The function computes the k-step diffusion \eqn{p_k = T^kp_0}, then computes the
Unbiased CrossValidation (UCV) criterion of Sain, Baggerly and Scott (1994).
This function can compute the UCV using either full matrix methods or sparse 
(default) matrix methods.  The latter are almost always much faster, though it 
is possible that if the number of points in the point pattern is large compared
to the number of nodes (an unlikely circumstance) that the full matrix method
would be quicker.  The sparse matrix approach typically uses less memory.  The
paper by Barry and McIntyre (2010) shows the approximation to the UCV used
in this approach.
}
\examples{
plot.new()
data(polygon1)
#
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.02)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
#
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
#
out <- crossvalDensity(formLatticeOutput,PointPattern=Pointdata, 
       M=0.5,max_steps = 70)
#
densityOut <- createDensity(formLatticeOutput,PointPattern=Pointdata, 
                          k=out$k,intensity=FALSE, sparse = TRUE)
plot(densityOut)
#
homerange(densityOut, percent = 0.95) 
}
\references{
Crossvalidation of Multivariate Densities.
Stephan R. Sain, Keith A. Baggerly, David W. Scott; Journal of the American 
Statistical Association, Vol. 89 (1994) 807-817

Julie McIntyre, Ronald P. Barry (2018)  A Lattice-Based 
Smoother for Regions with Irregular Boundaries and Holes.  
Journal of Computational and Graphical Statistics.  In Press.
}
