% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTmatrix.R
\name{makeTmatrix}
\alias{makeTmatrix}
\title{Create the transition matrix for the diffusion.}
\usage{
makeTmatrix(formLatticeOutput, M = 0.5, sparse = TRUE)
}
\arguments{
\item{formLatticeOutput}{A formLatticeOutput object, returned 
by the functions formLattice or by the function editLattice.}

\item{M}{A smoothing parameter. It is the maximum probability 
that the random walk moves from the node in a single step. 
It is a maximum probability in the sense that this is the
movement probability for nodes not near a boundary.  Of course,
near a boundary movement will be constrained proportional to
how many neighbors the node has.  Thus if interior nodes have
eight neighbors, a node with only four neighbors will move half as 
often.
Since the number of steps k also determines smoothing,
M is usually left at 0.5. Note that values of M=1 or M=0 
can lead to pathological results. The paper of Barry and 
McIntyre (2011) shows the exact construction of the 
transition matrix.}

\item{sparse}{logical. If TRUE, then uses sparse matrix 
computations from packages spdep and spam. If FALSE, 
uses full matrix computations. The use of sparse matrices 
is almost always more efficient.}
}
\value{
An NxN transition matrix, where N is the number of nodes.
}
\description{
This function generates a transition matrix for 
the diffusion process on the lattice.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.02)
formLatticeOutput <- formLattice(nodeFillingOutput)
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
poly.area <- splancs::areapl(polygon1)
init_prob <- addObservations(formLatticeOutput, Pointdata)
T = makeTmatrix(formLatticeOutput, M = 0.5, sparse=TRUE)
p10 <- Tkp(T, 10, p=init_prob$init_prob)
head(cbind(init_prob$init_prob, p10))

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating animal 
densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative 
to the kernel density estimator. Ecological Modelling 
222 (2011) 1666-1672.
}
\author{
Ronald P. Barry
}
